/* dvBed.h was originally generated by the autoSql program, which also 
 * generated dvBed.c and dvBed.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef DVBED_H
#define DVBED_H

#define DVBED_NUM_COLS 4

struct dvBed
/* core disease variation data */
    {
    struct dvBed *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome */
    unsigned chromStart;	/* Start position in chrom */
    unsigned chromEnd;	/* End position in chrom */
    char *name;	/* BAC Name */
    };

void dvBedStaticLoad(char **row, struct dvBed *ret);
/* Load a row from dvBed table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct dvBed *dvBedLoad(char **row);
/* Load a dvBed from row fetched with select * from dvBed
 * from database.  Dispose of this with dvBedFree(). */

struct dvBed *dvBedLoadAll(char *fileName);
/* Load all dvBed from whitespace-separated file.
 * Dispose of this with dvBedFreeList(). */

struct dvBed *dvBedLoadAllByChar(char *fileName, char chopper);
/* Load all dvBed from chopper separated file.
 * Dispose of this with dvBedFreeList(). */

#define dvBedLoadAllByTab(a) dvBedLoadAllByChar(a, '\t');
/* Load all dvBed from tab separated file.
 * Dispose of this with dvBedFreeList(). */

struct dvBed *dvBedCommaIn(char **pS, struct dvBed *ret);
/* Create a dvBed out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new dvBed */

void dvBedFree(struct dvBed **pEl);
/* Free a single dynamically allocated dvBed such as created
 * with dvBedLoad(). */

void dvBedFreeList(struct dvBed **pList);
/* Free a list of dynamically allocated dvBed's */

void dvBedOutput(struct dvBed *el, FILE *f, char sep, char lastSep);
/* Print out dvBed.  Separate fields with sep. Follow last field with lastSep. */

#define dvBedTabOut(el,f) dvBedOutput(el,f,'\t','\n');
/* Print out dvBed as a line in a tab-separated file. */

#define dvBedCommaOut(el,f) dvBedOutput(el,f,',',',');
/* Print out dvBed as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* DVBED_H */

