/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.JsonArray;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryProvider;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import com.google.jstestdriver.Action;
import com.google.jstestdriver.ActionFactoryModule;
import com.google.jstestdriver.ActionListProvider;
import com.google.jstestdriver.BrowserAction;
import com.google.jstestdriver.FailureAccumulator;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileSetProvider;
import com.google.jstestdriver.Flags;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.Time;
import com.google.jstestdriver.TimeImpl;
import com.google.jstestdriver.action.ConfigureProxyAction;
import com.google.jstestdriver.annotations.BrowserCount;
import com.google.jstestdriver.browser.BrowserRunner;
import com.google.jstestdriver.guice.BrowserActionProvider;
import com.google.jstestdriver.guice.FlagsModule;
import java.io.File;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsTestDriverModule
extends AbstractModule {
    private final Flags flags;
    private final Set<FileInfo> fileSet;
    private final String serverAddress;
    private final PrintStream outputStream;
    private final File basePath;
    private final long testSuiteTimeout;
    private final List<FileInfo> tests;
    private final List<FileInfo> plugins;
    private final JsonArray proxyConfig;

    public JsTestDriverModule(Flags flags, Set<FileInfo> fileSet, String serverAddress, PrintStream outputStream, File basePath) {
        this(flags, fileSet, serverAddress, outputStream, basePath, 7200L, Collections.emptyList(), Collections.emptyList(), new JsonArray());
    }

    public JsTestDriverModule(Flags flags, Set<FileInfo> fileSet, String serverAddress, PrintStream outputStream, File basePath, long testSuiteTimeout, List<FileInfo> tests, List<FileInfo> plugins, JsonArray proxyConfig) {
        this.flags = flags;
        this.fileSet = fileSet;
        this.serverAddress = serverAddress;
        this.outputStream = outputStream;
        this.basePath = basePath;
        this.testSuiteTimeout = testSuiteTimeout;
        this.tests = tests;
        this.plugins = plugins;
        this.proxyConfig = proxyConfig;
    }

    @Override
    protected void configure() {
        this.bind(PrintStream.class).annotatedWith(Names.named("outputStream")).toInstance(this.outputStream);
        this.bind(String.class).annotatedWith(Names.named("server")).toInstance(this.serverAddress);
        this.bind(Boolean.class).annotatedWith(Names.named("raiseOnFailure")).toInstance(true);
        this.bind(new TypeLiteral<Set<FileInfo>>(){}).annotatedWith(Names.named("originalFileSet")).toInstance(this.fileSet);
        this.bind(new TypeLiteral<List<Action>>(){}).toProvider(ActionListProvider.class);
        this.bind(new TypeLiteral<List<BrowserAction>>(){}).toProvider(BrowserActionProvider.class);
        this.bind(ExecutorService.class).toInstance(Executors.newScheduledThreadPool(10));
        this.bind(FailureAccumulator.class).in(Singleton.class);
        this.bind(Long.class).annotatedWith(Names.named("testSuiteTimeout")).toInstance(this.testSuiteTimeout);
        this.bind(File.class).annotatedWith(Names.named("basePath")).toInstance(this.basePath);
        this.install(new FlagsModule(this.flags));
        this.install(new ActionFactoryModule());
        for (BrowserRunner runner : this.flags.getBrowser()) {
            Multibinder.newSetBinder(this.binder(), BrowserRunner.class).addBinding().toInstance(runner);
        }
        this.bind(Time.class).to(TimeImpl.class);
        this.bind(new TypeLiteral<Set<FileInfo>>(){}).annotatedWith(Names.named("fileSet")).toProvider(FileSetProvider.class).in(Singleton.class);
        this.bind(new TypeLiteral<List<FileInfo>>(){}).annotatedWith(Names.named("tests")).toInstance(this.tests);
        this.bind(new TypeLiteral<List<FileInfo>>(){}).annotatedWith(Names.named("plugins")).toInstance(this.plugins);
        this.bind(Integer.class).annotatedWith(BrowserCount.class).toProvider(BrowserCountProvider.class).in(Singleton.class);
        this.bind(JsonArray.class).annotatedWith(Names.named("proxy")).toInstance(this.proxyConfig);
        this.bind(ConfigureProxyAction.Factory.class).toProvider(FactoryProvider.newFactory(ConfigureProxyAction.Factory.class, ConfigureProxyAction.class));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BrowserCountProvider
    implements Provider<Integer> {
        private final JsTestDriverClient client;

        @Inject
        public BrowserCountProvider(JsTestDriverClient client) {
            this.client = client;
        }

        @Override
        public synchronized Integer get() {
            try {
                return this.client.listBrowsers().size();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot inject the browser count until the server has started. Try injecting a Provider of it instead.", e);
            }
        }
    }
}

