/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.HashMap;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.internal.artifacts.DefaultResolvedDependency;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ModuleVersionIdentifierSerializer;
import org.gradle.api.internal.artifacts.configurations.ResolutionHost;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DependencyArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.RootGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.DefaultTransientConfigurationResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResults;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.internal.BinaryStore;
import org.gradle.cache.internal.Store;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;

public class TransientConfigurationResultsBuilder
implements DependencyArtifactsVisitor {
    private static final Logger LOG = Logging.getLogger(TransientConfigurationResultsBuilder.class);
    private static final byte NODE = 1;
    private static final byte ROOT = 2;
    private static final byte FIRST_LEVEL = 3;
    private static final byte EDGE = 4;
    private static final byte NODE_ARTIFACTS = 5;
    private final Object lock = new Object();
    private final BinaryStore binaryStore;
    private final Store<TransientConfigurationResults> cache;
    private final BuildOperationExecutor buildOperationExecutor;
    private final ResolutionHost resolutionHost;
    private final ModuleVersionIdentifierSerializer moduleVersionIdSerializer;
    private BinaryStore.BinaryData binaryData;

    public TransientConfigurationResultsBuilder(BinaryStore binaryStore, Store<TransientConfigurationResults> cache, ImmutableModuleIdentifierFactory moduleIdentifierFactory, BuildOperationExecutor buildOperationExecutor, ResolutionHost resolutionHost) {
        this.moduleVersionIdSerializer = new ModuleVersionIdentifierSerializer(moduleIdentifierFactory);
        this.binaryStore = binaryStore;
        this.cache = cache;
        this.buildOperationExecutor = buildOperationExecutor;
        this.resolutionHost = resolutionHost;
    }

    @Override
    public void visitNode(DependencyGraphNode node) {
        this.binaryStore.write(encoder -> {
            encoder.writeByte((byte)1);
            encoder.writeSmallLong(node.getNodeId());
            this.moduleVersionIdSerializer.write(encoder, node.getComponent().getId());
            encoder.writeString((CharSequence)node.getMetadata().getName());
        });
        for (DependencyGraphEdge dependencyGraphEdge : node.getIncomingEdges()) {
            if (!dependencyGraphEdge.getFrom().isRoot()) continue;
            this.firstLevelDependency(node.getNodeId());
        }
    }

    @Override
    public void finishArtifacts(RootGraphNode root) {
        this.binaryStore.write(encoder -> {
            encoder.writeByte((byte)2);
            encoder.writeSmallLong(root.getNodeId());
        });
        this.binaryData = this.binaryStore.done();
    }

    public void firstLevelDependency(Long id) {
        this.binaryStore.write(encoder -> {
            encoder.writeByte((byte)3);
            encoder.writeSmallLong(id.longValue());
        });
    }

    @Override
    public void visitArtifacts(DependencyGraphNode from, DependencyGraphNode to, int artifactSetId, ArtifactSet artifacts) {
        this.binaryStore.write(encoder -> {
            encoder.writeByte((byte)4);
            encoder.writeSmallLong(from.getNodeId());
            encoder.writeSmallLong(to.getNodeId());
            encoder.writeSmallInt(artifactSetId);
        });
    }

    @Override
    public void visitArtifacts(DependencyGraphNode from, LocalFileDependencyMetadata fileDependency, int artifactSetId, ArtifactSet artifactSet) {
        this.binaryStore.write(encoder -> {
            encoder.writeByte((byte)5);
            encoder.writeSmallLong(from.getNodeId());
            encoder.writeSmallInt(artifactSetId);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransientConfigurationResults load(SelectedArtifactResults artifactResults) {
        Object object = this.lock;
        synchronized (object) {
            return (TransientConfigurationResults)this.cache.load(() -> {
                try {
                    TransientConfigurationResults transientConfigurationResults = (TransientConfigurationResults)this.binaryData.read(decoder -> this.deserialize(decoder, artifactResults, this.buildOperationExecutor, this.resolutionHost));
                    return transientConfigurationResults;
                }
                finally {
                    try {
                        this.binaryData.close();
                    }
                    catch (IOException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                }
            });
        }
    }

    private TransientConfigurationResults deserialize(Decoder decoder, SelectedArtifactResults artifactResults, BuildOperationExecutor buildOperationProcessor, ResolutionHost resolutionHost) {
        Timer clock = Time.startTimer();
        HashMap<Long, DefaultResolvedDependency> allDependencies = new HashMap<Long, DefaultResolvedDependency>();
        ImmutableSet.Builder firstLevelDependencies = ImmutableSet.builder();
        int valuesRead = 0;
        int type = -1;
        try {
            block9: while (true) {
                type = decoder.readByte();
                ++valuesRead;
                switch (type) {
                    case 1: {
                        long id = decoder.readSmallLong();
                        ModuleVersionIdentifier moduleVersionId = this.moduleVersionIdSerializer.read(decoder);
                        String variantName = decoder.readString();
                        allDependencies.put(id, new DefaultResolvedDependency(variantName, moduleVersionId, buildOperationProcessor, resolutionHost));
                        continue block9;
                    }
                    case 2: {
                        long id = decoder.readSmallLong();
                        ResolvedDependency root = (ResolvedDependency)allDependencies.get(id);
                        if (root == null) {
                            throw new IllegalStateException(String.format("Unexpected root id %s. Seen ids: %s", id, allDependencies.keySet()));
                        }
                        LOG.debug("Loaded resolved configuration results ({}) from {}", (Object)clock.getElapsed(), (Object)this.binaryStore);
                        return new DefaultTransientConfigurationResults(root, (ImmutableSet<ResolvedDependency>)firstLevelDependencies.build());
                    }
                    case 3: {
                        long id = decoder.readSmallLong();
                        DefaultResolvedDependency dependency = (DefaultResolvedDependency)allDependencies.get(id);
                        if (dependency == null) {
                            throw new IllegalStateException(String.format("Unexpected first level id %s. Seen ids: %s", id, allDependencies.keySet()));
                        }
                        firstLevelDependencies.add((Object)dependency);
                        continue block9;
                    }
                    case 4: {
                        long parentId = decoder.readSmallLong();
                        long childId = decoder.readSmallLong();
                        DefaultResolvedDependency parent = (DefaultResolvedDependency)allDependencies.get(parentId);
                        DefaultResolvedDependency child = (DefaultResolvedDependency)allDependencies.get(childId);
                        if (parent == null) {
                            throw new IllegalStateException(String.format("Unexpected parent dependency id %s. Seen ids: %s", parentId, allDependencies.keySet()));
                        }
                        if (child == null) {
                            throw new IllegalStateException(String.format("Unexpected child dependency id %s. Seen ids: %s", childId, allDependencies.keySet()));
                        }
                        parent.addChild(child);
                        ResolvedArtifactSet artifacts = artifactResults.getArtifactsWithId(decoder.readSmallInt());
                        child.addParentSpecificArtifacts(parent, artifacts);
                        continue block9;
                    }
                    case 5: {
                        long id = decoder.readSmallLong();
                        DefaultResolvedDependency node = (DefaultResolvedDependency)allDependencies.get(id);
                        if (node == null) {
                            throw new IllegalStateException(String.format("Unexpected node id %s. Seen ids: %s", node, allDependencies.keySet()));
                        }
                        ResolvedArtifactSet artifacts = artifactResults.getArtifactsWithId(decoder.readSmallInt());
                        node.addModuleArtifacts(artifacts);
                        continue block9;
                    }
                }
                break;
            }
            throw new IOException("Unknown value type read from stream: " + type);
        }
        catch (IOException e) {
            throw new RuntimeException("Problems loading the resolved configuration. Read " + valuesRead + " values, last was: " + type, e);
        }
    }
}

