/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.fileevents.internal;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.gradle.fileevents.FileWatchEvent;
import org.gradle.fileevents.internal.AbstractFileEventFunctions;
import org.gradle.fileevents.internal.AbstractNativeFileEventFunctions;

public class OsxFileEventFunctions
extends AbstractNativeFileEventFunctions<OsxFileWatcher> {
    private static final long DEFAULT_LATENCY_IN_MS = 0L;

    public WatcherBuilder newWatcher(BlockingQueue<FileWatchEvent> eventQueue) {
        return new WatcherBuilder(eventQueue);
    }

    private static native Object startWatcher0(long var0, AbstractFileEventFunctions.NativeFileWatcherCallback var2);

    public static class WatcherBuilder
    extends AbstractFileEventFunctions.AbstractWatcherBuilder<OsxFileWatcher> {
        private long latencyInMillis = 0L;

        WatcherBuilder(BlockingQueue<FileWatchEvent> eventQueue) {
            super(eventQueue);
        }

        public WatcherBuilder withLatency(long latency, TimeUnit unit) {
            this.latencyInMillis = unit.toMillis(latency);
            return this;
        }

        @Override
        protected OsxFileWatcher createWatcher(AbstractFileEventFunctions.NativeFileWatcherCallback callback) {
            Object server = OsxFileEventFunctions.startWatcher0(this.latencyInMillis, callback);
            return new OsxFileWatcher(server, callback);
        }
    }

    public static class OsxFileWatcher
    extends AbstractNativeFileEventFunctions.NativeFileWatcher {
        public OsxFileWatcher(Object server, AbstractFileEventFunctions.NativeFileWatcherCallback callback) {
            super(server, callback);
        }
    }
}

