/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.downloader.connector;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.installer.downloader.connector.MyProxyType;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.xml.DomExternalizable;
import org.netbeans.installer.utils.xml.DomUtil;
import org.netbeans.installer.utils.xml.visitors.DomVisitor;
import org.netbeans.installer.utils.xml.visitors.RecursiveDomVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MyProxy
implements DomExternalizable {
    private static final Map<Proxy.Type, MyProxyType> type2Type = new HashMap<Proxy.Type, MyProxyType>();
    int port = -1;
    String host = "";
    MyProxyType type = MyProxyType.DIRECT;
    public static final String ERROR_TYPES_CONFLICT_KEY = "MP.error.types.conflict";
    public static final String PROXY_TAG = "proxy";
    public static final String PROXY_TYPE_TAG = "proxy-type";
    public static final String PROXY_HOST_TAG = "proxy-host";
    public static final String PROXY_PORT_TAG = "proxy-port";
    public static final String SELECTOR_PROXIES_TAG = "selector-proxies";

    public MyProxy() {
    }

    public MyProxy(Proxy proxy) {
        this.type = type2Type.get((Object)proxy.type());
        InetSocketAddress address = (InetSocketAddress)proxy.address();
        if (address != null) {
            this.host = address.getHostName();
            this.port = address.getPort();
        }
    }

    public MyProxy(Proxy proxy, MyProxyType type) throws IllegalArgumentException {
        this(proxy);
        if (proxy.type() != type.getType()) {
            throw new IllegalArgumentException(ResourceUtils.getString(MyProxy.class, ERROR_TYPES_CONFLICT_KEY, new Object[]{proxy.type(), type.getType()}));
        }
        this.type = type;
    }

    public Proxy getProxy() {
        return this.type == MyProxyType.DIRECT ? Proxy.NO_PROXY : new Proxy(this.type.getType(), new InetSocketAddress(this.host, this.port));
    }

    @Override
    public void readXML(Element element) {
        RecursiveDomVisitor visitor = new RecursiveDomVisitor(){

            @Override
            public void visit(Element element) {
                if (MyProxy.PROXY_TYPE_TAG.equals(element.getNodeName())) {
                    MyProxy.this.type = MyProxyType.valueOf(element.getTextContent().trim().toUpperCase());
                } else if (MyProxy.PROXY_HOST_TAG.equals(element.getNodeName())) {
                    MyProxy.this.host = element.getTextContent().trim();
                } else if (MyProxy.PROXY_PORT_TAG.equals(element.getNodeName())) {
                    MyProxy.this.port = Integer.parseInt(element.getTextContent().trim());
                } else {
                    super.visit(element);
                }
            }
        };
        ((DomVisitor)visitor).visit(element);
    }

    @Override
    public Element writeXML(Document document) {
        Element root = document.createElement(PROXY_TAG);
        DomUtil.addElement(root, PROXY_TYPE_TAG, this.type.toString());
        DomUtil.addElement(root, PROXY_HOST_TAG, this.host);
        DomUtil.addElement(root, PROXY_PORT_TAG, String.valueOf(this.port));
        return root;
    }

    public boolean equals(Object proxy) {
        if (this == proxy) {
            return true;
        }
        if (proxy == null) {
            return false;
        }
        if (proxy instanceof MyProxy) {
            MyProxy prox = (MyProxy)proxy;
            if (this.port == prox.port && this.type == prox.type && this.host.equals(prox.host)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 29 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 29 * result + this.port;
        return result;
    }

    static {
        type2Type.put(Proxy.Type.DIRECT, MyProxyType.DIRECT);
        type2Type.put(Proxy.Type.HTTP, MyProxyType.HTTP);
        type2Type.put(Proxy.Type.SOCKS, MyProxyType.SOCKS);
    }
}

