/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.impl.lcdui;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import javax.microedition.midlet.ApplicationManager;
import org.me4se.impl.lcdui.PhysicalFont;
import org.me4se.impl.skins.Skin;

public class BitmapFont
extends PhysicalFont {
    private BufferedImage image;
    private int[] data;
    private String fileName;
    HashMap cache = new HashMap();
    private int[] pos = new int[65280];

    public BitmapFont(Skin skin, String file) throws IOException {
        String s;
        ApplicationManager manager = ApplicationManager.getInstance();
        BufferedReader reader = new BufferedReader(new InputStreamReader(manager.openInputStream(skin.getName(file))));
        while ((s = reader.readLine()) != null) {
            int code;
            int cut = s.indexOf(61);
            if (cut == -1) continue;
            String key = s.substring(0, cut).trim().toLowerCase();
            String value = s.substring(cut + 1).trim();
            if (key.equals("font_image")) {
                this.fileName = skin.getName(value);
                this.image = manager.getImage(this.fileName);
                continue;
            }
            if (key.equals("font_height")) {
                this.height = Integer.parseInt(value);
                continue;
            }
            if (key.equals("font_ascent")) {
                this.ascent = Integer.parseInt(value);
                continue;
            }
            if (key.equals("font_descent")) {
                this.descent = Integer.parseInt(value);
                continue;
            }
            if (key.equals("font_leading")) {
                this.leading = Integer.parseInt(value);
                continue;
            }
            if (key.startsWith("ascii_x-")) {
                code = Integer.parseInt(key.substring(8));
                this.pos[code] = Integer.parseInt(value);
                continue;
            }
            if (key.startsWith("ascii_w-")) {
                code = Integer.parseInt(key.substring(8));
                int w = Integer.parseInt(value);
                for (int i = code + 1; i < this.pos.length; ++i) {
                    this.pos[i] = this.pos[i - 1] + w;
                }
                continue;
            }
            if (key.startsWith("0x")) {
                code = Integer.parseInt(key.substring(2), 16);
                this.pos[code] = Integer.parseInt(value);
                continue;
            }
            System.err.println("unrecognized: " + key + "=" + value);
        }
        if (this.image == null) {
            throw new RuntimeException("Image not loaded!");
        }
    }

    public int charWidth(char c) {
        if (c >= this.pos.length - 1) {
            c = (char)63;
        }
        return this.pos[c + '\u0001'] - this.pos[c];
    }

    public void drawChar(Graphics g, char c, int x, int y) {
        if (c >= this.pos.length) {
            c = (char)63;
        }
        int ix = this.pos[c];
        int w = this.charWidth(c);
        int color = g.getColor().getRGB() | g.getColor().getAlpha() << 24;
        if ((color & 0xFF000000) == 0) {
            return;
        }
        Integer ci = new Integer(color);
        BufferedImage img = (BufferedImage)this.cache.get(ci);
        if (img == null) {
            if (this.cache.size() > 256) {
                System.out.println("Clearing font cache (size > 256)");
            }
            System.out.println("Font color " + color + " not in cache, building.... ");
            if (this.data == null) {
                this.data = new int[this.image.getHeight() * this.image.getWidth()];
                this.image.getRGB(0, 0, this.image.getWidth(), this.image.getHeight(), this.data, 0, this.image.getWidth());
            }
            img = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 2);
            for (int i = 0; i < this.data.length; ++i) {
                if ((this.data[i] & 0xFF000000) == 0) continue;
                this.data[i] = color;
            }
            img.setRGB(0, 0, this.image.getWidth(), this.image.getHeight(), this.data, 0, this.image.getWidth());
            this.cache.put(ci, img);
        }
        g.drawImage(img, x, y - this.ascent, x + w, y - this.ascent + this.height, ix, 0, ix + w, this.height, null);
    }

    public void drawString(Graphics g, String s, int x, int y) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            this.drawChar(g, c, x, y);
            x += this.charWidth(c);
        }
    }
}

