/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.specs.Spec;
import org.gradle.composite.internal.BuildController;
import org.gradle.composite.internal.BuildControllers;
import org.gradle.composite.internal.BuildTreeWorkGraphController;
import org.gradle.composite.internal.DefaultBuildControllers;
import org.gradle.composite.internal.IncludedBuildTaskResource;
import org.gradle.composite.internal.TaskIdentifier;
import org.gradle.execution.EntryTaskSelector;
import org.gradle.execution.plan.PlanExecutor;
import org.gradle.execution.plan.QueryableExecutionPlan;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.build.ExportedTaskNode;
import org.gradle.internal.buildtree.BuildTreeWorkGraph;
import org.gradle.internal.buildtree.BuildTreeWorkGraphPreparer;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.taskgraph.CalculateTreeTaskGraphBuildOperationType;
import org.gradle.internal.work.WorkerLeaseService;

public class DefaultIncludedBuildTaskGraph
implements BuildTreeWorkGraphController,
Closeable {
    private static final int MONITORING_POLL_TIME = 30;
    private final BuildOperationExecutor buildOperationExecutor;
    private final BuildStateRegistry buildRegistry;
    private final WorkerLeaseService workerLeaseService;
    private final PlanExecutor planExecutor;
    private final BuildTreeWorkGraphPreparer workGraphPreparer;
    private final int monitoringPollTime;
    private final TimeUnit monitoringPollTimeUnit;
    private final ManagedExecutor executorService;
    private final ThreadLocal<DefaultBuildTreeWorkGraph> current = new ThreadLocal();

    @Inject
    public DefaultIncludedBuildTaskGraph(ExecutorFactory executorFactory, BuildOperationExecutor buildOperationExecutor, BuildStateRegistry buildRegistry, WorkerLeaseService workerLeaseService, PlanExecutor planExecutor, BuildTreeWorkGraphPreparer workGraphPreparer) {
        this(executorFactory, buildOperationExecutor, buildRegistry, workerLeaseService, planExecutor, workGraphPreparer, 30, TimeUnit.SECONDS);
    }

    @VisibleForTesting
    DefaultIncludedBuildTaskGraph(ExecutorFactory executorFactory, BuildOperationExecutor buildOperationExecutor, BuildStateRegistry buildRegistry, WorkerLeaseService workerLeaseService, PlanExecutor planExecutor, BuildTreeWorkGraphPreparer workGraphPreparer, int monitoringPollTime, TimeUnit monitoringPollTimeUnit) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.buildRegistry = buildRegistry;
        this.executorService = executorFactory.create("included builds");
        this.workerLeaseService = workerLeaseService;
        this.planExecutor = planExecutor;
        this.workGraphPreparer = workGraphPreparer;
        this.monitoringPollTime = monitoringPollTime;
        this.monitoringPollTimeUnit = monitoringPollTimeUnit;
    }

    private DefaultBuildControllers createControllers() {
        return new DefaultBuildControllers(this.executorService, this.workerLeaseService, this.planExecutor, this.monitoringPollTime, this.monitoringPollTimeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withNewWorkGraph(Function<? super BuildTreeWorkGraph, T> action) {
        DefaultBuildTreeWorkGraph previous = this.current.get();
        DefaultBuildTreeWorkGraph workGraph = new DefaultBuildTreeWorkGraph();
        this.current.set(workGraph);
        try {
            T t;
            try {
                t = action.apply(workGraph);
                workGraph.close();
            }
            catch (Throwable throwable) {
                workGraph.close();
                throw throwable;
            }
            return t;
        }
        finally {
            this.current.set(previous);
        }
    }

    public IncludedBuildTaskResource locateTask(TaskIdentifier taskIdentifier) {
        return this.withState(workGraph -> {
            BuildState build = this.buildRegistry.getBuild(taskIdentifier.getBuildIdentifier());
            ExportedTaskNode taskNode = build.getWorkGraph().locateTask(taskIdentifier);
            return new TaskBackedResource((DefaultBuildTreeWorkGraph)workGraph, build, taskNode);
        });
    }

    @Override
    public void close() throws IOException {
        CompositeStoppable.stoppable((Object[])new Object[]{this.executorService});
    }

    private <T> T withState(Function<DefaultBuildTreeWorkGraph, T> action) {
        DefaultBuildTreeWorkGraph workGraph = this.current.get();
        if (workGraph == null) {
            throw new IllegalStateException("No work graph available for this thread.");
        }
        workGraph.assertIsOwner();
        return action.apply(workGraph);
    }

    private static class TaskBackedResource
    implements IncludedBuildTaskResource {
        private final DefaultBuildTreeWorkGraph workGraph;
        private final BuildState build;
        private final ExportedTaskNode taskNode;

        public TaskBackedResource(DefaultBuildTreeWorkGraph workGraph, BuildState build, ExportedTaskNode taskNode) {
            this.workGraph = workGraph;
            this.build = build;
            this.taskNode = taskNode;
        }

        public void queueForExecution() {
            this.workGraph.queueForExecution(this.build, this.taskNode);
        }

        public void onComplete(Runnable action) {
            this.taskNode.onComplete(action);
        }

        public TaskInternal getTask() {
            return this.taskNode.getTask();
        }

        public IncludedBuildTaskResource.State getTaskState() {
            return this.taskNode.getTaskState();
        }

        public String healthDiagnostics() {
            return this.taskNode.healthDiagnostics();
        }
    }

    private class DefaultBuildTreeWorkGraph
    implements BuildTreeWorkGraph,
    BuildTreeWorkGraph.FinalizedGraph,
    AutoCloseable {
        private final Thread owner;
        private final BuildControllers controllers;
        private State state = State.NotPrepared;

        public DefaultBuildTreeWorkGraph() {
            this.owner = Thread.currentThread();
            this.controllers = DefaultIncludedBuildTaskGraph.this.createControllers();
        }

        public void queueForExecution(BuildState build, ExportedTaskNode taskNode) {
            this.assertIsOwner();
            this.assertCanQueueTask();
            this.controllers.getBuildController(build).queueForExecution(taskNode);
        }

        public BuildTreeWorkGraph.FinalizedGraph scheduleWork(final Consumer<? super BuildTreeWorkGraph.Builder> action) {
            this.assertIsOwner();
            this.expectInState(State.NotPrepared);
            this.state = State.Preparing;
            DefaultIncludedBuildTaskGraph.this.buildOperationExecutor.run(new RunnableBuildOperation(){

                public void run(BuildOperationContext context) {
                    DefaultBuildTreeWorkGraphBuilder graphBuilder = new DefaultBuildTreeWorkGraphBuilder(DefaultBuildTreeWorkGraph.this);
                    DefaultIncludedBuildTaskGraph.this.workGraphPreparer.prepareToScheduleTasks((BuildTreeWorkGraph.Builder)graphBuilder);
                    action.accept(graphBuilder);
                    DefaultBuildTreeWorkGraph.this.controllers.populateWorkGraphs();
                    context.setResult((Object)new CalculateTreeTaskGraphBuildOperationType.Result(){});
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)"Calculate build tree task graph").details((Object)new CalculateTreeTaskGraphBuildOperationType.Details(){});
                }
            });
            this.state = State.ReadyToRun;
            return this;
        }

        public ExecutionResult<Void> runWork() {
            this.assertIsOwner();
            this.expectInState(State.ReadyToRun);
            this.state = State.Running;
            try {
                ExecutionResult<Void> executionResult = this.controllers.execute();
                return executionResult;
            }
            finally {
                this.state = State.Finished;
            }
        }

        @Override
        public void close() {
            this.assertIsOwner();
            this.controllers.close();
        }

        private void assertCanQueueTask() {
            this.expectInState(State.Preparing);
        }

        private void expectInState(State expectedState) {
            if (this.state != expectedState) {
                throw this.unexpectedState();
            }
        }

        private IllegalStateException unexpectedState() {
            return new IllegalStateException("Work graph is in an unexpected state: " + (Object)((Object)this.state));
        }

        private void assertIsOwner() {
            if (Thread.currentThread() != this.owner) {
                throw new IllegalStateException("Current thread is not the owner of this work graph.");
            }
        }
    }

    private class DefaultBuildTreeWorkGraphBuilder
    implements BuildTreeWorkGraph.Builder {
        private final DefaultBuildTreeWorkGraph owner;

        public DefaultBuildTreeWorkGraphBuilder(DefaultBuildTreeWorkGraph owner) {
            this.owner = owner;
        }

        public void withWorkGraph(BuildState target, Consumer<? super BuildLifecycleController.WorkGraphBuilder> action) {
            this.buildControllerOf(target).populateWorkGraph(action);
        }

        public void addFilter(BuildState target, Spec<Task> filter) {
            this.buildControllerOf(target).addFilter(filter);
        }

        public void addFinalization(BuildState target, BiConsumer<EntryTaskSelector.Context, QueryableExecutionPlan> finalization) {
            this.buildControllerOf(target).addFinalization(finalization);
        }

        public void scheduleTasks(Collection<TaskIdentifier.TaskBasedTaskIdentifier> tasksToBuild) {
            for (TaskIdentifier.TaskBasedTaskIdentifier identifier : tasksToBuild) {
                if (identifier.getTask().getState().getExecuted()) continue;
                DefaultIncludedBuildTaskGraph.this.locateTask((TaskIdentifier)identifier).queueForExecution();
            }
        }

        private BuildController buildControllerOf(BuildState target) {
            return this.owner.controllers.getBuildController(target);
        }
    }

    private static enum State {
        NotPrepared,
        Preparing,
        ReadyToRun,
        Running,
        Finished;

    }
}

