/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.gamemode.abilitycategory;

import java.util.Collection;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.enumeration.Type;
import pcgen.core.AbilityCategory;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class TypeToken
extends AbstractNonEmptyToken<AbilityCategory>
implements CDOMPrimaryToken<AbilityCategory>,
DeferredToken<AbilityCategory> {
    public String getTokenName() {
        return "TYPE";
    }

    public ParseResult parseNonEmptyToken(LoadContext context, AbilityCategory ac, String value) {
        if ("*".equals(value)) {
            ac.setAllAbilityTypes(true);
            return ParseResult.SUCCESS;
        }
        ParseResult pr = this.checkForIllegalSeparator('.', value);
        if (!pr.passed()) {
            return pr;
        }
        StringTokenizer st = new StringTokenizer(value, ".");
        while (st.hasMoreTokens()) {
            String typeString = st.nextToken();
            if ("*".equals(typeString)) {
                return new ParseResult.Fail("Use of named types along with TYPE:* in category " + ac.getDisplayName() + " is invalid.  Found: " + value, context);
            }
            ac.addAbilityType(Type.getConstant((String)typeString));
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, AbilityCategory ac) {
        if (ac.isAllAbilityTypes()) {
            return new String[]{"*"};
        }
        Set types = ac.getTypes();
        if (types.isEmpty()) {
            return null;
        }
        return new String[]{StringUtil.join((Collection)types, (String)".")};
    }

    public Class<AbilityCategory> getTokenClass() {
        return AbilityCategory.class;
    }

    public Class<AbilityCategory> getDeferredTokenClass() {
        return AbilityCategory.class;
    }

    public boolean process(LoadContext context, AbilityCategory ac) {
        if (ac.isAllAbilityTypes()) {
            if (!ac.getTypes().isEmpty()) {
                Logging.log((Level)Logging.LST_ERROR, (String)("Use of named types along with TYPE:* in category " + ac.getDisplayName() + " is invalid."));
                return false;
            }
            if (ac.hasDirectReferences()) {
                Logging.log((Level)Logging.LST_ERROR, (String)("Use of ABILITYLIST along with TYPE:* in category " + ac.getDisplayName() + " is invalid."));
                return false;
            }
        }
        return true;
    }
}

