/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.skill;

import pcgen.core.kit.KitSkill;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class FreeToken
extends AbstractNonEmptyToken<KitSkill>
implements CDOMPrimaryToken<KitSkill> {
    @Override
    public String getTokenName() {
        return "FREE";
    }

    @Override
    public Class<KitSkill> getTokenClass() {
        return KitSkill.class;
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, KitSkill kitSkill, String value) {
        Boolean set;
        char firstChar = value.charAt(0);
        if (firstChar == 'y' || firstChar == 'Y') {
            if (value.length() > 1 && !value.equalsIgnoreCase("YES")) {
                return new ParseResult.Fail("You should use 'YES' as the " + this.getTokenName() + ": " + value, context);
            }
            set = Boolean.TRUE;
        } else {
            if (firstChar != 'N' && firstChar != 'n') {
                return new ParseResult.Fail("You should use 'YES' or 'NO' as the " + this.getTokenName() + ": " + value, context);
            }
            if (value.length() > 1 && !value.equalsIgnoreCase("NO")) {
                return new ParseResult.Fail("You should use 'YES' or 'NO' as the " + this.getTokenName() + ": " + value, context);
            }
            set = Boolean.FALSE;
        }
        kitSkill.setFree(set);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, KitSkill kitSkill) {
        Boolean mult = kitSkill.getFree();
        if (mult == null) {
            return null;
        }
        return new String[]{mult != false ? "YES" : "NO"};
    }
}

