/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.gamemode.abilitycategory;

import pcgen.core.AbilityCategory;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.enumeration.Visibility;

public class VisibleToken
extends AbstractNonEmptyToken<AbilityCategory>
implements CDOMPrimaryToken<AbilityCategory> {
    @Override
    public String getTokenName() {
        return "VISIBLE";
    }

    @Override
    public ParseResult parseNonEmptyToken(LoadContext context, AbilityCategory ac, String value) {
        Visibility vis;
        if (value.equals("YES")) {
            vis = Visibility.DEFAULT;
        } else if (value.equals("QUALIFY")) {
            vis = Visibility.QUALIFY;
        } else if (value.equals("NO")) {
            vis = Visibility.HIDDEN;
        } else {
            return new ParseResult.Fail("Unable to understand " + this.getTokenName() + " tag: " + value, context);
        }
        ac.setVisible(vis);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, AbilityCategory ac) {
        String visString;
        Visibility vis = ac.getVisibility();
        if (vis.equals((Object)Visibility.DEFAULT)) {
            visString = "YES";
        } else if (vis.equals((Object)Visibility.QUALIFY)) {
            visString = "QUALIFY";
        } else if (vis.equals((Object)Visibility.HIDDEN)) {
            visString = "NO";
        } else {
            context.addWriteMessage("Visibility " + (Object)((Object)vis) + " is not a valid Visibility for " + ac.getClass().getSimpleName() + " " + ac.getKeyName());
            return null;
        }
        return new String[]{visString};
    }

    @Override
    public Class<AbilityCategory> getTokenClass() {
        return AbilityCategory.class;
    }
}

