/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence.token;

import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Converter;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.PrimitiveFilter;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.character.CharacterSpell;
import pcgen.core.spell.Spell;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.PrimitiveToken;
import pcgen.util.Logging;

public abstract class AbstractRestrictedSpellPrimitive
implements PrimitiveToken<Spell>,
PrimitiveFilter<Spell> {
    private static final Class<Spell> SPELL_CLASS = Spell.class;
    private Restriction restriction;
    private CDOMReference<Spell> allSpells;

    public boolean initialize(LoadContext context, String args) {
        this.allSpells = context.getReferenceContext().getCDOMAllReference(SPELL_CLASS);
        if (args != null) {
            this.restriction = this.getRestriction(args);
            return this.restriction != null;
        }
        return true;
    }

    private Restriction getRestriction(String restrString) {
        StringTokenizer restr = new StringTokenizer(restrString, ";");
        Formula levelMax = null;
        Formula levelMin = null;
        Boolean known = null;
        while (restr.hasMoreTokens()) {
            String tok = restr.nextToken();
            if (tok.startsWith("LEVELMAX=")) {
                levelMax = FormulaFactory.getFormulaFor(tok.substring(9));
                if (levelMax.isValid()) continue;
                Logging.errorPrint("LEVELMAX Formula in " + this.getTokenName() + " was not valid: " + levelMax.toString());
                return null;
            }
            if (tok.startsWith("LEVELMIN=")) {
                levelMin = FormulaFactory.getFormulaFor(tok.substring(9));
                if (levelMin.isValid()) continue;
                Logging.errorPrint("LEVELMIN Formula in " + this.getTokenName() + " was not valid: " + levelMin.toString());
                return null;
            }
            if ("KNOWN=YES".equals(tok)) {
                known = Boolean.TRUE;
                continue;
            }
            if ("KNOWN=NO".equals(tok)) {
                known = Boolean.FALSE;
                continue;
            }
            Logging.errorPrint("Unknown restriction: " + tok + " in CHOOSE:SPELLS");
            return null;
        }
        return new Restriction(levelMin, levelMax, known);
    }

    @Override
    public Class<Spell> getReferenceClass() {
        return SPELL_CLASS;
    }

    @Override
    public String getLSTformat(boolean useAny) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPrimitiveLST());
        return sb.toString();
    }

    public abstract CharSequence getPrimitiveLST();

    public boolean allow(PlayerCharacter pc, int level, String source, Spell spell, CDOMList<Spell> optionalList) {
        if (this.restriction != null) {
            Formula maxLevel = this.restriction.maxLevel;
            if (maxLevel != null && level > maxLevel.resolve(pc, source).intValue()) {
                return false;
            }
            Formula minLevel = this.restriction.minLevel;
            if (minLevel != null && level < minLevel.resolve(pc, source).intValue()) {
                return false;
            }
            if (this.restriction.knownRequired != null) {
                String defaultbook = Globals.getDefaultSpellBook();
                boolean known = this.restriction.knownRequired;
                boolean found = false;
                for (PCClass cl : pc.getClassSet()) {
                    List<CharacterSpell> csl;
                    if (optionalList != null && !pc.hasSpellList(cl, optionalList) || (csl = pc.getCharacterSpells(cl, spell, defaultbook, -1)) == null || csl.isEmpty()) continue;
                    found = true;
                }
                if (found != known) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean equalsRestrictedPrimitive(AbstractRestrictedSpellPrimitive other) {
        if (other == this) {
            return true;
        }
        if (this.restriction == null) {
            return other.restriction == null;
        }
        return this.restriction.equals(other.restriction);
    }

    public boolean hasRestriction() {
        return this.restriction != null;
    }

    public String getRestrictionLST() {
        return this.restriction == null ? "" : '[' + this.restriction.getLSTformat() + ']';
    }

    @Override
    public <R> Collection<? extends R> getCollection(PlayerCharacter pc, Converter<Spell, R> c) {
        return c.convert(this.allSpells, this);
    }

    private static class Restriction {
        public final Formula minLevel;
        public final Formula maxLevel;
        public final Boolean knownRequired;

        public Restriction(Formula levelMin, Formula levelMax, Boolean known) {
            this.minLevel = levelMin;
            this.maxLevel = levelMax;
            this.knownRequired = known;
        }

        public String getLSTformat() {
            StringBuilder sb = new StringBuilder();
            if (this.knownRequired != null) {
                sb.append("KNOWN=");
                sb.append(this.knownRequired != false ? "YES" : "NO");
            }
            if (this.maxLevel != null) {
                if (sb.length() > 0) {
                    sb.append(';');
                }
                sb.append("LEVELMAX=");
                sb.append(this.maxLevel);
            }
            if (this.minLevel != null) {
                if (sb.length() > 0) {
                    sb.append(';');
                }
                sb.append("LEVELMIN=");
                sb.append(this.minLevel);
            }
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = prime * result + (this.knownRequired == null ? 0 : this.knownRequired.hashCode());
            result = prime * result + (this.maxLevel == null ? 0 : this.maxLevel.hashCode());
            result = prime * result + (this.minLevel == null ? 0 : this.minLevel.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Restriction other = (Restriction)obj;
            if (this.knownRequired == null ? other.knownRequired != null : !this.knownRequired.equals(other.knownRequired)) {
                return false;
            }
            if (this.maxLevel == null ? other.maxLevel != null : !this.maxLevel.equals(other.maxLevel)) {
                return false;
            }
            return !(this.minLevel == null ? other.minLevel != null : !this.minLevel.equals(other.minLevel));
        }
    }
}

