/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.term;

import pcgen.cdom.helper.ClassSource;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.character.CharacterSpell;
import pcgen.core.term.BasePCTermEvaluator;
import pcgen.core.term.TermEvaluator;

public class PCCasterLevelClassTermEvaluator
extends BasePCTermEvaluator
implements TermEvaluator {
    private final String source;

    public PCCasterLevelClassTermEvaluator(String originalText, String source) {
        this.originalText = originalText;
        this.source = source;
    }

    @Override
    public Float resolve(PlayerCharacter pc) {
        return Float.valueOf(0.0f);
    }

    @Override
    public Float resolve(PlayerCharacter pc, CharacterSpell aSpell) {
        Double d1;
        Domain domain = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Domain.class, this.source);
        ClassSource cs = pc.getDomainSource(domain);
        String varSource = cs != null ? cs.getPcclass().getKeyName() : this.source;
        PCClass spClass = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCClass.class, varSource);
        String spellType = "None";
        if (spClass != null && !spClass.getSpellType().equals("None")) {
            spellType = spClass.getSpellType();
        }
        int pcBonus = (d1 = Double.valueOf(pc.getTotalBonusTo("PCLEVEL", varSource))) == null ? 0 : d1.intValue();
        Double d2 = pc.getTotalBonusTo("CASTERLEVEL", varSource);
        int castBonus = d2 == null ? 0 : d2.intValue();
        int iClass = spClass != null && castBonus == 0 ? pc.getDisplay().getLevel(spClass) : 0;
        return Float.valueOf(pc.getTotalCasterLevelWithSpellBonus(aSpell, aSpell.getSpell(), spellType, varSource, iClass + pcBonus));
    }

    @Override
    public boolean isSourceDependant() {
        return true;
    }

    public boolean isStatic() {
        return false;
    }
}

