/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.reference;

import java.util.ArrayList;
import java.util.Collection;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.reference.CDOMGroupRef;

public class PatternMatchingReference<T extends Loadable>
extends CDOMReference<T> {
    private final CDOMGroupRef<T> all;
    private final String pattern;

    public PatternMatchingReference(Class<T> objClass, CDOMGroupRef<T> startingGroup, String patternText) {
        super(objClass, patternText);
        if (startingGroup == null) {
            throw new IllegalArgumentException("Starting Group cannot be null in PatternMatchingReference");
        }
        this.all = startingGroup;
        String lstPattern = "%";
        int patternchar = patternText.length() - lstPattern.length();
        if (patternText.indexOf(lstPattern) != patternchar) {
            throw new IllegalArgumentException("Pattern for PatternMatchingReference must end with " + lstPattern);
        }
        this.pattern = patternText.substring(0, patternchar);
    }

    @Override
    public void addResolution(T item) {
        throw new IllegalStateException("Cannot add resolution to PatternMatchingReference");
    }

    @Override
    public boolean contains(T item) {
        return this.all.contains(item) && item.getKeyName().startsWith(this.pattern);
    }

    @Override
    public Collection<T> getContainedObjects() {
        ArrayList<Loadable> list = new ArrayList<Loadable>();
        for (Loadable obj : this.all.getContainedObjects()) {
            if (!obj.getKeyName().startsWith(this.pattern)) continue;
            list.add(obj);
        }
        return list;
    }

    @Override
    public String getLSTformat(boolean useAny) {
        return this.getName();
    }

    @Override
    public int getObjectCount() {
        int count = 0;
        for (Loadable obj : this.all.getContainedObjects()) {
            if (!obj.getKeyName().startsWith(this.pattern)) continue;
            ++count;
        }
        return count;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PatternMatchingReference) {
            PatternMatchingReference other = (PatternMatchingReference)obj;
            return this.getReferenceClass().equals(other.getReferenceClass()) && this.all.equals(other.all) && this.pattern.equals(other.pattern);
        }
        return false;
    }

    public int hashCode() {
        return this.getReferenceClass().hashCode() ^ this.pattern.hashCode();
    }

    @Override
    public GroupingState getGroupingState() {
        return GroupingState.ANY;
    }

    @Override
    public String getChoice() {
        return null;
    }
}

