/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.content.factset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import pcgen.base.util.Indirect;
import pcgen.base.util.ObjectContainer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.content.factset.FactSetInfo;
import pcgen.rules.context.AbstractReferenceContext;
import pcgen.rules.context.LoadContext;

public class FactSetGroup<T extends CDOMObject, F>
implements ObjectContainer<T> {
    private final FactSetInfo<T, F> def;
    private final Indirect<F> toMatch;
    private final ObjectContainer<T> allObjects;
    private List<T> cache;

    public FactSetGroup(LoadContext context, FactSetInfo<T, F> fsi, String value) {
        if (fsi.getUsableLocation().equals(CDOMObject.class)) {
            throw new IllegalArgumentException("FactSetGroup cannot be global");
        }
        this.def = fsi;
        AbstractReferenceContext refContext = context.getReferenceContext();
        this.allObjects = refContext.getCDOMAllReference(this.def.getUsableLocation());
        this.toMatch = this.def.getFormatManager().convertIndirect(value);
        if (this.toMatch == null) {
            throw new IllegalArgumentException("Failed to convert " + value + " as a " + this.def.getFormatManager().getManagedClass().getSimpleName());
        }
    }

    public Collection<T> getContainedObjects() {
        if (this.cache == null) {
            ArrayList<T> setupCache = new ArrayList<T>();
            for (CDOMObject obj : this.allObjects.getContainedObjects()) {
                if (!this.contains((T)obj)) continue;
                setupCache.add(obj);
            }
            this.cache = setupCache;
        }
        return Collections.unmodifiableCollection(this.cache);
    }

    public String getLSTformat(boolean useAny) {
        return this.def.getFactSetName() + "=" + this.def.getFormatManager().unconvert(this.toMatch.resolvesTo());
    }

    public boolean contains(T obj) {
        List<ObjectContainer<F>> factset = ((CDOMObject)obj).getSetFor(this.def.getFactSetKey());
        if (factset != null) {
            Object tgt = this.toMatch.resolvesTo();
            for (ObjectContainer<F> oc : factset) {
                if (!oc.contains(tgt)) continue;
                return true;
            }
        }
        return false;
    }

    public Class<T> getReferenceClass() {
        return this.allObjects.getReferenceClass();
    }
}

