/*
 * Decompiled with CFR 0.152.
 */
package plugin.dicebag.gui;

import gmgen.GMGenSystem;
import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import javax.swing.JOptionPane;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import pcgen.core.RollingMethods;
import pcgen.util.Logging;

public class DiceBagModel
extends Observable {
    private List<String> m_dice = new ArrayList<String>();
    private String m_filePath;
    private String m_name = "";
    private boolean m_changed = false;

    public DiceBagModel() {
    }

    public DiceBagModel(String name) {
        this();
        this.m_name = name;
    }

    public DiceBagModel(File file) {
        this();
        this.loadFromFile(file);
    }

    public boolean isBagEmpty() {
        return this.m_dice.isEmpty();
    }

    public boolean isChanged() {
        return this.m_changed;
    }

    public String setDie(int index, String element) {
        this.m_changed = true;
        return this.m_dice.set(index, element);
    }

    public String getDie(int index) {
        return this.m_dice.get(index);
    }

    public String getFilePath() {
        return this.m_filePath;
    }

    public void setName(String string) {
        this.m_changed = true;
        this.m_name = string;
    }

    public String getName() {
        return this.m_name;
    }

    public void addDie(int index, String element) {
        this.m_dice.add(index, element);
        this.m_changed = true;
    }

    public boolean addDie(String o) {
        this.m_changed = true;
        return this.m_dice.add(o);
    }

    public void clearDice() {
        this.m_changed = true;
        this.m_dice.clear();
    }

    public int diceCount() {
        return this.m_dice.size();
    }

    public String removeDie(int index) {
        this.m_changed = true;
        return this.m_dice.remove(index);
    }

    public double rollDie(int index) {
        double returnValue = 0.0;
        if (index < this.m_dice.size()) {
            returnValue = RollingMethods.roll((String)this.m_dice.get(index));
        }
        return returnValue;
    }

    public double rollDie(String expression) {
        double returnValue = RollingMethods.roll((String)expression);
        return returnValue;
    }

    public void saveToFile(File file) {
        try {
            Document doc = new Document();
            this.saveToDocument(doc);
            XMLOutputter xmlOut = new XMLOutputter();
            xmlOut.setFormat(Format.getPrettyFormat());
            FileWriter fr = new FileWriter(file);
            xmlOut.output(doc, (Writer)fr);
            fr.flush();
            fr.close();
            this.m_filePath = file.getPath();
            this.m_changed = false;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)GMGenSystem.inst, "File load error: " + file.getName());
            Logging.errorPrint((String)("File Load Error" + file.getName()));
            Logging.errorPrint((String)e.getMessage(), (Throwable)e);
        }
    }

    private void loadFromDocument(Document doc) {
        this.m_dice.clear();
        Element root = doc.getRootElement();
        if (root.getName().equals("dice-bag")) {
            this.m_name = root.getAttributeValue("name");
            List children = root.getChildren("dice-roll");
            for (Element die : children) {
                this.m_dice.add(die.getTextNormalize());
            }
        }
    }

    private void loadFromFile(File file) {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(file);
            this.m_filePath = file.getPath();
            this.loadFromDocument(doc);
            this.m_changed = false;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)GMGenSystem.inst, "File load error: " + file.getName());
            Logging.errorPrint((String)("File Load Error" + file.getName()));
            Logging.errorPrint((String)e.getMessage(), (Throwable)e);
        }
    }

    private void saveToDocument(Document doc) {
        Element party = new Element("dice-bag");
        party.setAttribute("name", this.m_name);
        for (String dieString : this.m_dice) {
            Element die = new Element("dice-roll");
            die.addContent(dieString);
            party.addContent((Content)die);
        }
        doc.setRootElement(party);
    }
}

