/////////////////////////////////////////////////////////////////////////////
//
// Format: MSA
//
// Used by: Psyvariar Complete Edition, maybe other PS2 games.
//
/////////////////////////////////////////////////////////////////////////////

#include "headers.h"

#include "fmt.h"
#include "rip.h"

/////////////////////////////////////////////////////////////////////////////

int fmt_msa_detect(FILE *inf, const char *ext) {
  int score = 50;

  // base the entire test on the file extension for now
  if(!strcasecmp(ext, "msa")) return 90;

  return score;
}

/////////////////////////////////////////////////////////////////////////////

int fmt_msa_rip(
  FILE *inf,
  struct OPTIONS *opts
) {
  struct OPTIONS myopts;
  uint8 hdr[0x14];

  if(opts) { memcpy(&myopts, opts, sizeof(myopts)); }
  else { memset(&myopts, 0, sizeof(myopts)); }

  if(myopts.use_offset) fseek(inf, myopts.offset, SEEK_CUR);
  myopts.use_offset = 0;

  fread(hdr, 1, 0x14, inf);

  if(!myopts.use_channels) {
    myopts.use_channels = 1;
    myopts.channels = 2;
  }
  if(!myopts.use_honor_endflag) {
    myopts.use_honor_endflag = 1;
    myopts.honor_endflag = 1;
  }
  if(!myopts.use_samplerate) {
    myopts.use_samplerate = 1;
    myopts.samplerate = get32lsb(hdr + 0x10);
    if(myopts.samplerate < 8000 || myopts.samplerate > 48000) {
      myopts.samplerate = 44100;
    }
  }
  if(!myopts.use_interleave) {
    myopts.use_interleave = 1;
    myopts.interleave = 0x4000;
  }

  return rip(inf, &myopts, NULL);
}

/////////////////////////////////////////////////////////////////////////////
