/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.navigation;

import com.jgoodies.application.ResourceMap;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.jsdl.util.IconUtils;
import com.jgoodies.common.swing.ScreenScaling;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.components.JGSearchField;
import com.jgoodies.components.internal.TextFieldSupport;
import com.jgoodies.components.util.NullIcon;
import com.jgoodies.fluent.Theme;
import com.jgoodies.fluent.internal.FluentButtonFactory;
import com.jgoodies.fluent.internal.FluentStatefulBorder;
import com.jgoodies.fluent.navigation.BackButton;
import com.jgoodies.fluent.navigation.NavigationView;
import com.jgoodies.fluent.navigation.SplitView;
import com.jgoodies.fluent.resources.Fluent;
import com.jgoodies.layout.builder.FormBuilder;
import com.jgoodies.layout.factories.Forms;
import com.jgoodies.layout.factories.Paddings;
import com.jgoodies.layout.layout.RowSpec;
import com.jgoodies.navigation.Page;
import com.jgoodies.navigation.PageModel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;

final class NavigationPane {
    private final PageModel pageModel;
    private final LayoutMode layoutMode;
    private final NavigationPaneFactory factory;
    private final List<JComponent> headerItems = new ArrayList<JComponent>();
    private final List<JComponent> items = new ArrayList<JComponent>();
    private final List<JComponent> footerItems = new ArrayList<JComponent>();

    NavigationPane(LayoutMode layoutMode, Theme theme, PageModel pageModel) {
        this.layoutMode = layoutMode;
        this.pageModel = pageModel;
        this.factory = new NavigationPaneFactory(theme, layoutMode);
    }

    void addBackButton() {
        BackButton backButton = this.factory.createBackButton(this.pageModel);
        backButton.getComponent().addActionListener(NavigationPane::closeOverlayPane);
        JPanel backPanel = ((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("left:pref", new Object[0])).rows("f:p", new Object[0])).add(backButton.getComponent()).xy(1, 1)).build();
        this.headerItems.add(backPanel);
    }

    void addMenuButton(String title, ActionListener onMenuButtonPerformed) {
        AbstractButton menuButton = this.factory.createMenuButton(title);
        menuButton.addActionListener(onMenuButtonPerformed);
        ResourceMap resources = new Fluent().getResourceMap(menuButton.getLocale());
        menuButton.setToolTipText(resources.getString("NavigationView.Menu." + (this.layoutMode.isCompact() ? "compact" : "open"), new Object[0]));
        this.headerItems.add(menuButton);
    }

    void addHeader(Action action) {
        this.headerItems.add(this.factory.createHeaderOrFooterButton(action));
    }

    void addSearchField(JGSearchField searchField, ActionListener openPaneHandler) {
        switch (this.layoutMode) {
            case LEFT_OPEN: 
            case LEFT_MINIMAL_OPEN: {
                this.headerItems.add(this.factory.createPaddedSearchFieldLeft(searchField));
                break;
            }
            case LEFT_COMPACT: {
                AbstractButton searchButton = this.factory.createSearchButton();
                searchButton.addActionListener(openPaneHandler);
                this.headerItems.add(searchButton);
                break;
            }
            case TOP: {
                this.footerItems.add(this.factory.createPaddedSearchFieldTop(searchField));
                break;
            }
        }
    }

    void addNavigationElements(List<NavigationView.NavigationElement> elements) {
        for (NavigationView.NavigationElement element : elements) {
            if (element instanceof NavigationView.NavigationItem) {
                this.addItem((NavigationView.NavigationItem)element);
                continue;
            }
            if (element instanceof NavigationView.NavigationItemHeader) {
                this.addItemHeader((NavigationView.NavigationItemHeader)element);
                continue;
            }
            if (!(element instanceof NavigationView.NavigationSeparator)) continue;
            this.addItemSeparator((NavigationView.NavigationSeparator)element);
        }
    }

    void addFooter(Action action) {
        this.footerItems.add(this.factory.createHeaderOrFooterButton(action));
    }

    void addSettings(NavigationView.NavigationItem settingsItem) {
        Icon icon = settingsItem.icon;
        String text = settingsItem.page.getDisplayString();
        JToggleButton toggleButton = this.factory.createPageButton(icon, text);
        if (this.layoutMode == LayoutMode.TOP) {
            toggleButton.setToolTipText(text);
            toggleButton.setHideActionText(true);
        }
        toggleButton.setModel(new CurrentPageRadioButtonAdapter(toggleButton, this.pageModel, settingsItem.page));
        this.footerItems.add(toggleButton);
    }

    private void addItem(NavigationView.NavigationItem item) {
        Icon icon = item.icon;
        String name = item.name;
        Page page = item.page;
        if (this.layoutMode.isCompact() && icon == null) {
            return;
        }
        JToggleButton toggleButton = this.factory.createPageButton(this.layoutMode.isTop() ? null : icon, name != null ? name : page.getDisplayString());
        toggleButton.setModel(new CurrentPageRadioButtonAdapter(toggleButton, this.pageModel, page));
        this.items.add(toggleButton);
    }

    private void addItemHeader(NavigationView.NavigationItemHeader header) {
        if (!this.layoutMode.isLeftOpen()) {
            return;
        }
        this.items.add(this.factory.createPaddedItemHeader(header.name));
    }

    private void addItemSeparator(NavigationView.NavigationSeparator separator) {
        if (this.layoutMode != LayoutMode.LEFT_OPEN) {
            return;
        }
        this.items.add(new JPanel(null));
    }

    JComponent buildPanel() {
        return this.layoutMode == LayoutMode.TOP ? this.buildPanelTop() : this.buildPanelLeft();
    }

    private JComponent buildPanelLeft() {
        String firstRowSpec = "f:48epx";
        String rowSpec = "f:[40epx,p]";
        FormBuilder builder = (FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("fill:%s", this.layoutMode == LayoutMode.LEFT_COMPACT ? "48epx" : "pref")).rows(new RowSpec[0])).background(this.factory.getTheme().background());
        int y = 1;
        for (JComponent component : this.headerItems) {
            builder.appendRows(y == 1 ? "f:48epx" : "f:[40epx,p]", new Object[0]);
            builder.add(component).xy(1, y++);
        }
        builder.appendRows("fill:0:grow", new Object[0]);
        builder.add(this.buildItemsPanel()).xy(1, y++);
        for (JComponent component : this.footerItems) {
            builder.appendRows("f:[40epx,p]", new Object[0]);
            builder.add(component).xy(1, y++);
        }
        return builder.build();
    }

    private JComponent buildPanelTop() {
        FormBuilder builder = (FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("", new Object[0])).rows("f:48epx", new Object[0])).background(this.factory.getTheme().background());
        int x = 1;
        for (JComponent component : this.headerItems) {
            builder.appendColumns("pref", new Object[0]);
            builder.add(component).xy(x++, 1);
        }
        builder.appendColumns("pref", new Object[0]);
        builder.add(this.buildItemsPanel()).xy(x++, 1);
        builder.appendColumns("0:grow", new Object[0]);
        ++x;
        for (JComponent component : this.footerItems) {
            builder.appendColumns("pref", new Object[0]);
            builder.add(component).xy(x++, 1);
        }
        return builder.build();
    }

    private JComponent buildItemsPanel() {
        return this.layoutMode == LayoutMode.TOP ? this.buildItemsPanelTop() : this.buildItemsPanelLeft();
    }

    private JComponent buildItemsPanelLeft() {
        FormBuilder builder = (FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("fill:%s", this.layoutMode == LayoutMode.LEFT_COMPACT ? "48epx" : "[48epx,pref]:grow")).rows("%s*(f:40epx)", this.items.size())).background(this.factory.getTheme().background());
        int y = 1;
        for (JComponent component : this.items) {
            builder.add(component).xy(1, y++);
        }
        if (this.layoutMode != LayoutMode.LEFT_OPEN) {
            return builder.build();
        }
        JScrollPane scrollPane = JGComponentFactory.getCurrent().createStrippedScrollPane(builder.build());
        scrollPane.getVerticalScrollBar().setUnitIncrement(5);
        return scrollPane;
    }

    private JComponent buildItemsPanelTop() {
        FormBuilder builder = (FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("%s*(p)", this.items.size())).rows("f:48epx", new Object[0])).background(this.factory.getTheme().background());
        int x = 1;
        for (JComponent component : this.items) {
            builder.add(component).xy(x++, 1);
        }
        return builder.build();
    }

    static void closeOverlayPane(ActionEvent evt) {
        Component source = (Component)evt.getSource();
        SplitView view = NavigationPane.getSplitViewParent(source);
        if (view != null) {
            view.closeOverlayPane();
        }
    }

    private static SplitView getSplitViewParent(Component c) {
        for (Component p = c; p != null; p = p.getParent()) {
            if (!(p instanceof SplitView)) continue;
            return (SplitView)p;
        }
        return null;
    }

    static final class CloseOverlayAction
    extends AbstractAction {
        CloseOverlayAction(String text, Icon icon) {
            super(text, IconUtils.pad(icon, ScreenScaling.physicalInsets(5, 3, 0, 0)));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            NavigationPane.closeOverlayPane(evt);
        }
    }

    static final class CurrentPageRadioButtonAdapter
    extends JToggleButton.ToggleButtonModel {
        private final JToggleButton button;
        private final PageModel pageModel;
        private final Page page;

        public CurrentPageRadioButtonAdapter(JToggleButton button, PageModel pageModel, Page page) {
            this.button = Preconditions.checkNotNull(button, "The %s must not be null.", "button");
            this.pageModel = Preconditions.checkNotNull(pageModel, "The %s must not be null.", "page model");
            this.page = Preconditions.checkNotNull(page, "The %s must not be null.", "page");
            this.initEventHandling();
        }

        private void initEventHandling() {
            this.pageModel.addPropertyChangeListener("currentPage", this::onCurrentPageChanged);
            this.updateSelectedState();
        }

        @Override
        public void setSelected(boolean b) {
            if (!b || this.isSelected()) {
                return;
            }
            this.pageModel.navigate(this.button, this.page);
            this.updateSelectedState();
        }

        @Override
        public void setGroup(ButtonGroup group) {
            if (group != null) {
                throw new UnsupportedOperationException("You need not and must not use a ButtonGroup with a set of RadioButtonAdapters. These form a group by sharing the same subject ValueModel.");
            }
        }

        private void onCurrentPageChanged(PropertyChangeEvent evt) {
            this.updateSelectedState();
        }

        private void updateSelectedState() {
            boolean pageIsCurrentPage = this.page.equalsPage(this.pageModel.getCurrentPage());
            super.setSelected(pageIsCurrentPage);
        }
    }

    static enum LayoutMode {
        LEFT_OPEN,
        LEFT_COMPACT,
        LEFT_MINIMAL,
        LEFT_MINIMAL_OPEN,
        TOP;


        boolean isLeft() {
            return this != TOP;
        }

        boolean isLeftMinimal() {
            return this == LEFT_MINIMAL;
        }

        boolean isLeftOpen() {
            return this == LEFT_OPEN || this == LEFT_MINIMAL_OPEN;
        }

        boolean isTop() {
            return this == TOP;
        }

        boolean isCompact() {
            return this == LEFT_COMPACT || this == LEFT_MINIMAL;
        }

        boolean hasBackButton() {
            return this != LEFT_MINIMAL;
        }
    }

    static final class NavigationPaneFactory
    extends FluentButtonFactory {
        private static final int ICON_TEXT_GAP_LEFT = ScreenScaling.toPhysical(14);
        private final LayoutMode layoutMode;
        private static final int EPX14 = ScreenScaling.toPhysical(14);
        private static final int EPX19 = ScreenScaling.toPhysical(19);
        private static final int EPX48 = ScreenScaling.toPhysical(48);
        private static final Insets EPX4_UP_INSETS = ScreenScaling.physicalInsets(0, 0, 4, 0);

        NavigationPaneFactory(Theme theme, LayoutMode layoutMode) {
            super(theme);
            this.layoutMode = layoutMode;
        }

        BackButton createBackButton(PageModel pageModel) {
            return new BackButton(pageModel, this.getTheme());
        }

        AbstractButton createMenuButton(String title) {
            JButton button = this.createButton(title, this.fluentResources.getNavigationViewMenuIcon());
            button.setFont(this.fluentResources.getAppBarTitleFont());
            return button;
        }

        AbstractButton createSearchButton() {
            JButton button = this.createButton(this.fluentResources.getNavigationViewSearchIcon());
            button.setToolTipText(this.fluentResources.getNavigationViewSearchText());
            return button;
        }

        JComponent createPaddedSearchFieldLeft(JGSearchField searchField) {
            this.configureSearchField(searchField);
            return Forms.paddedGrow(searchField, "6epx, 13epx, 7epx, 15epx", new Object[0]);
        }

        JComponent createPaddedSearchFieldTop(JGSearchField searchField) {
            this.configureSearchField(searchField);
            return Forms.paddedGrow(searchField, "9epx, 0epx, 8epx, 0epx", new Object[0]);
        }

        JComponent createPaddedItemHeader(String headerText) {
            JLabel label = new JLabel(headerText);
            label.setFont(this.fluentResources.getAppBarButtonSelectedFont());
            label.setBorder(Paddings.createPadding("0, 14epx, 0, 0", new Object[0]));
            return label;
        }

        AbstractButton createHeaderOrFooterButton(Action action) {
            JButton button = this.createButton(action);
            button.setForeground(this.getTheme().foreground());
            if (this.layoutMode == LayoutMode.TOP) {
                button.setHideActionText(true);
            } else if (this.layoutMode.isLeftOpen()) {
                button.setToolTipText(null);
            } else if (this.layoutMode.isCompact() && Strings.isEmpty(button.getToolTipText())) {
                button.setToolTipText((String)action.getValue("Name"));
            }
            return button;
        }

        JToggleButton createPageButton(Icon icon, String text) {
            Icon paddedIcon = icon == null ? (this.isTop() ? null : new NullIcon(EPX48, EPX48)) : IconUtils.pad(icon, EPX4_UP_INSETS);
            FluentButtonFactory.NavigationToggleButton toggleButton = this.createToggleButton(new CloseOverlayAction(text, paddedIcon), this.isTop() ? FluentButtonFactory.SelectionMarkerMode.HORIZONTAL : FluentButtonFactory.SelectionMarkerMode.VERTICAL);
            if (this.isCompact()) {
                toggleButton.setToolTipText(text);
            }
            return toggleButton;
        }

        private void configureSearchField(JGSearchField searchField) {
            TextFieldSupport.setIcon(searchField, IconUtils.pad(this.fluentResources.getNavigationViewSearchFieldIcon(), ScreenScaling.physicalInsets(0, 0, 0, 8)));
            searchField.setFont(this.fluentResources.getAppBarButtonFont());
            searchField.setPromptStyle(0);
            FluentStatefulBorder.installOn(searchField, this.getTheme());
        }

        @Override
        protected void configureButton(AbstractButton button) {
            super.configureButton(button);
            button.setHideActionText(this.isCompact());
            button.setHorizontalAlignment(this.isTop() ? 0 : 10);
            if (this.isLeft()) {
                Icon icon = button.getIcon();
                int defaultWidth = EPX19;
                int iconWidth = icon == null ? defaultWidth : icon.getIconWidth();
                int extraWidth = iconWidth - defaultWidth;
                int defaultLead = EPX14;
                button.setBorder(Paddings.createPadding("0, %spx, 0epx, 12epx", defaultLead - extraWidth / 2));
                button.setIconTextGap(ICON_TEXT_GAP_LEFT - (extraWidth - extraWidth / 2));
            }
        }

        private boolean isCompact() {
            return this.layoutMode == LayoutMode.LEFT_COMPACT;
        }

        private boolean isLeft() {
            return this.layoutMode.isLeft();
        }

        private boolean isTop() {
            return this.layoutMode.isTop();
        }
    }
}

