/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.manager;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import javax.swing.JOptionPane;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jrm.misc.Log;
import jrm.misc.Settings;
import jrm.profile.manager.ProfileNFO;
import org.apache.commons.compress.utils.Sets;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.DOMException;

public class Import {
    public final File org_file;
    public File file;
    public File roms_file;
    public File sl_file;
    public boolean is_mame = false;

    public Import(File file, boolean sl) {
        this.org_file = file;
        File workdir = Settings.getWorkPath().toFile();
        File xmldir = new File(workdir, "xmlfiles");
        xmldir.mkdir();
        String ext = FilenameUtils.getExtension(file.getName());
        if (!Sets.newHashSet((Object[])new String[]{"xml", "dat"}).contains(ext.toLowerCase()) && file.canExecute()) {
            try {
                this.roms_file = this.importMame(file, false);
                if (this.roms_file != null) {
                    this.sl_file = sl ? this.importMame(file, true) : null;
                    this.file = ProfileNFO.saveJrm(File.createTempFile("JRM", ".jrm"), this.roms_file, this.sl_file);
                    this.is_mame = true;
                }
            }
            catch (IOException | ParserConfigurationException | TransformerException | DOMException e) {
                JOptionPane.showMessageDialog(null, e, "Exception", 0);
                e.printStackTrace();
            }
        } else {
            this.file = file;
        }
    }

    public File importMame(File file, boolean sl) {
        try {
            File tmpfile = File.createTempFile("JRM", sl ? ".jrm2" : ".jrm1");
            tmpfile.deleteOnExit();
            Process process = new ProcessBuilder(file.getAbsolutePath(), sl ? "-listsoftware" : "-listxml").directory(file.getAbsoluteFile().getParentFile()).start();
            try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpfile), Charset.forName("UTF-8")));
                 BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.forName("UTF-8")));){
                String line;
                boolean xml = false;
                while (null != (line = in.readLine())) {
                    if (line.startsWith("<?xml")) {
                        xml = true;
                    }
                    if (!xml) continue;
                    out.write(line + "\n");
                }
            }
            process.waitFor();
            return tmpfile;
        }
        catch (IOException e) {
            Log.err("Caught IO Exception", e);
        }
        catch (InterruptedException e) {
            Log.err("Caught Interrupted Exception", e);
        }
        return null;
    }
}

