/*
 * Decompiled with CFR 0.152.
 */
package jrm.compressors;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import jrm.compressors.Archive;
import jrm.compressors.ZipNArchive;
import jrm.compressors.ZipOptions;
import jrm.misc.FindCmd;
import jrm.misc.Settings;
import net.sf.sevenzipjbinding.SevenZipNativeInitializationException;
import org.apache.commons.io.FileUtils;

public class ZipArchive
implements Archive {
    private File tempDir = null;
    private File archive;
    private String cmd;
    private boolean readonly;
    private boolean is_7z;
    private static HashMap<String, File> archives = new HashMap();
    private ZipNArchive native_zip = null;

    public ZipArchive(File archive) throws IOException {
        this(archive, false);
    }

    public ZipArchive(File archive, boolean readonly) throws IOException {
        try {
            this.native_zip = new ZipNArchive(archive, readonly);
        }
        catch (SevenZipNativeInitializationException e) {
            this.readonly = readonly;
            this.archive = archive;
            this.cmd = Settings.getProperty("zip_cmd", FindCmd.find7z());
            if (!new File(this.cmd).exists() && !new File(this.cmd + ".exe").exists()) {
                throw new IOException(this.cmd + " does not exists");
            }
            this.archive = archives.get(archive.getAbsolutePath());
            if (null == this.archive) {
                this.archive = archive;
                archives.put(archive.getAbsolutePath(), this.archive);
            }
            this.is_7z = this.cmd.endsWith("7z") || this.cmd.endsWith("7z.exe");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.native_zip != null) {
            this.native_zip.close();
        } else if (this.tempDir != null) {
            if (this.readonly) {
                FileUtils.deleteDirectory(this.tempDir);
            } else {
                int err = -1;
                ArrayList<String> cmd_add = new ArrayList<String>();
                Path tmpfile = Files.createTempFile(this.archive.getParentFile().toPath(), "JRM", ".7z", new FileAttribute[0]);
                tmpfile.toFile().delete();
                if (this.is_7z) {
                    Collections.addAll(cmd_add, this.cmd, "a", "-r", "-t7z");
                    Collections.addAll(cmd_add, "-mx=" + Settings.getProperty("zip_level", ZipOptions.NORMAL.toString()));
                    Collections.addAll(cmd_add, tmpfile.toFile().getAbsolutePath(), "*");
                } else {
                    Collections.addAll(cmd_add, this.cmd, "-r");
                    Collections.addAll(cmd_add, "-" + Settings.getProperty("zip_level", ZipOptions.NORMAL.toString()));
                    Collections.addAll(cmd_add, tmpfile.toFile().getAbsolutePath(), "*");
                }
                Process process = new ProcessBuilder(cmd_add).directory(this.tempDir).redirectErrorStream(true).start();
                try {
                    err = process.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                FileUtils.deleteDirectory(this.tempDir);
                if (err != 0) {
                    Files.deleteIfExists(tmpfile);
                    throw new IOException("Process returned " + err);
                }
                File file = this.archive;
                synchronized (file) {
                    Files.move(tmpfile, this.archive.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            this.tempDir = null;
        }
    }

    @Override
    public File getTempDir() throws IOException {
        if (this.native_zip != null) {
            return this.native_zip.getTempDir();
        }
        if (this.tempDir == null) {
            this.tempDir = Files.createTempDirectory("JRM", new FileAttribute[0]).toFile();
            if (this.archive.exists() && !this.readonly) {
                if (this.extract(this.tempDir, null) == 0) {
                    return this.tempDir;
                }
                FileUtils.deleteDirectory(this.tempDir);
                this.tempDir = null;
            }
        }
        return this.tempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int extract(File baseDir, String entry) throws IOException {
        block22: {
            ArrayList<String> cmd = new ArrayList<String>();
            if (this.is_7z) {
                Collections.addAll(cmd, Settings.getProperty("7z_cmd", FindCmd.find7z()), "x", "-y", this.archive.getAbsolutePath());
                if (entry != null && !entry.isEmpty()) {
                    cmd.add(entry);
                }
                ProcessBuilder pb = new ProcessBuilder(cmd).directory(baseDir);
                File file = this.archive;
                synchronized (file) {
                    Process process = pb.start();
                    try {
                        return process.waitFor();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            try (FileSystem srcfs = FileSystems.newFileSystem(this.archive.toPath(), null);){
                if (entry != null && !entry.isEmpty()) {
                    Files.copy(srcfs.getPath(entry, new String[0]), baseDir.toPath().resolve(entry), new CopyOption[0]);
                    break block22;
                }
                final Path sourcePath = srcfs.getPath("/", new String[0]);
                final Path targetPath = baseDir.toPath();
                Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        Files.createDirectories(targetPath.resolve(sourcePath.relativize(dir)), new FileAttribute[0]);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.copy(file, targetPath.resolve(sourcePath.relativize(file)), new CopyOption[0]);
                        return FileVisitResult.CONTINUE;
                    }
                });
                int n = 0;
                return n;
            }
        }
        return -1;
    }

    @Override
    public File extract(String entry) throws IOException {
        File result;
        if (this.native_zip != null) {
            return this.native_zip.extract(entry);
        }
        if (this.readonly) {
            this.extract(this.getTempDir(), entry);
        }
        if ((result = new File(this.getTempDir(), entry)).exists()) {
            return result;
        }
        return null;
    }

    @Override
    public InputStream extract_stdout(String entry) throws IOException {
        if (this.native_zip != null) {
            return this.native_zip.extract_stdout(entry);
        }
        if (this.readonly) {
            this.extract(this.getTempDir(), entry);
        }
        return new FileInputStream(new File(this.getTempDir(), entry));
    }

    @Override
    public int add(String entry) throws IOException {
        if (this.native_zip != null) {
            return this.native_zip.add(entry);
        }
        return this.add(this.getTempDir(), entry);
    }

    @Override
    public int add(File baseDir, String entry) throws IOException {
        if (this.native_zip != null) {
            return this.native_zip.add(baseDir, entry);
        }
        if (this.readonly) {
            return -1;
        }
        if (!baseDir.equals(this.getTempDir())) {
            FileUtils.copyFile(new File(baseDir, entry), new File(this.getTempDir(), entry));
        }
        return 0;
    }

    @Override
    public int add_stdin(InputStream src, String entry) throws IOException {
        if (this.native_zip != null) {
            return this.native_zip.add_stdin(src, entry);
        }
        if (this.readonly) {
            return -1;
        }
        FileUtils.copyInputStreamToFile(src, new File(this.getTempDir(), entry));
        return 0;
    }

    @Override
    public int delete(String entry) throws IOException {
        if (this.native_zip != null) {
            return this.native_zip.delete(entry);
        }
        if (this.readonly) {
            return -1;
        }
        FileUtils.deleteQuietly(new File(this.getTempDir(), entry));
        return 0;
    }

    @Override
    public int rename(String entry, String newname) throws IOException {
        if (this.native_zip != null) {
            return this.native_zip.rename(entry, newname);
        }
        if (this.readonly) {
            return -1;
        }
        FileUtils.moveFile(new File(this.getTempDir(), entry), new File(this.getTempDir(), newname));
        return 0;
    }

    @Override
    public int duplicate(String entry, String newname) throws IOException {
        if (this.native_zip != null) {
            return this.native_zip.duplicate(entry, newname);
        }
        if (this.readonly) {
            return -1;
        }
        FileUtils.copyFile(new File(this.getTempDir(), entry), new File(this.getTempDir(), newname));
        return 0;
    }
}

