/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.format;

import java.util.Optional;
import java.util.function.Function;
import org.rundeck.client.tool.format.BaseDataOutputFormatter;
import org.rundeck.client.tool.format.Formatable;
import org.rundeck.client.tool.format.OutputFormatter;
import org.rundeck.client.tool.format.ToStringFormatter;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.representer.Representer;

public class YamlFormatter
extends BaseDataOutputFormatter {
    private final Yaml yaml;

    public YamlFormatter() {
        this(new ToStringFormatter());
    }

    public YamlFormatter(Representer representer, DumperOptions options) {
        this(new Yaml(representer, options), new ToStringFormatter());
    }

    public YamlFormatter(Function<Object, Optional<Formatable>> dataFormatter, Yaml yaml) {
        super(dataFormatter);
        this.yaml = yaml;
    }

    public YamlFormatter(OutputFormatter base) {
        this(new Yaml(), base);
    }

    public YamlFormatter(OutputFormatter base, Function<Object, Optional<Formatable>> dataFormatter, Yaml yaml) {
        super(base, dataFormatter);
        this.yaml = yaml;
    }

    private YamlFormatter(Yaml yaml, OutputFormatter base) {
        super(base);
        this.yaml = yaml;
    }

    @Override
    protected OutputFormatter withBase(Function<Object, Optional<Formatable>> dataFormatter, OutputFormatter base) {
        return new YamlFormatter(base, dataFormatter, this.yaml);
    }

    public YamlFormatter(OutputFormatter base, DumperOptions options) {
        super(base);
        this.yaml = new Yaml(options);
    }

    @Override
    protected boolean canFormatObject(Object value) {
        return true;
    }

    @Override
    protected String formatObject(Object o) {
        return this.yaml.dump(o);
    }
}

