/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import java.util.Collection;
import java.util.List;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.Conflict;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.GraphValidationException;
import org.gradle.internal.exceptions.ResolutionProvider;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.util.internal.TextUtil;

public class VersionConflictException
extends GraphValidationException
implements ResolutionProvider {
    private static final int MAX_SEEN_MODULE_COUNT = 10;
    private final Collection<Conflict> conflicts;
    private final List<String> resolutions;

    public VersionConflictException(Collection<Conflict> conflicts, List<String> resolutions) {
        super(VersionConflictException.buildMessage(conflicts));
        this.conflicts = conflicts;
        this.resolutions = resolutions;
    }

    public Collection<Conflict> getConflicts() {
        return this.conflicts;
    }

    private static String buildMessage(Collection<Conflict> conflicts) {
        TreeFormatter formatter = new TreeFormatter();
        String plural = TextUtil.getPluralEnding(conflicts);
        formatter.node("Conflict" + plural + " found for the following module" + plural);
        formatter.startChildren();
        conflicts.stream().limit(10L).forEach(conflict -> formatter.node(conflict.getMessage()));
        if (conflicts.size() > 10) {
            formatter.node("... and more");
        }
        formatter.endChildren();
        return formatter.toString();
    }

    public List<String> getResolutions() {
        return this.resolutions;
    }
}

