/*
 * Decompiled with CFR 0.152.
 */
package megamek.server.commands;

import java.util.Enumeration;
import megamek.common.Player;
import megamek.server.Server;

public abstract class ServerCommand {
    protected Server server;
    private String name;
    private String helpText;

    public ServerCommand(Server server, String string, String string2) {
        this.server = server;
        this.name = string;
        this.helpText = string2;
    }

    public String getName() {
        return this.name;
    }

    public String getHelp() {
        return this.helpText;
    }

    public abstract void run(int var1, String[] var2);

    public boolean canRunRestrictedCommand(int n) {
        if (!this.server.getGame().getOptions().booleanOption("restrict_game_commands")) {
            return true;
        }
        if (this.server.getPlayer(n).isGhost()) {
            return false;
        }
        if (this.server.getPlayer(n).isObserver()) {
            Enumeration<Player> enumeration = this.server.getGame().getPlayers();
            while (enumeration.hasMoreElements()) {
                Player player = enumeration.nextElement();
                if (player.isObserver() || player.isGhost()) continue;
                return false;
            }
        }
        return true;
    }
}

