/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Mounted;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoBayWeaponHandler;
import megamek.common.weapons.AttackHandler;
import megamek.common.weapons.BayWeapon;
import megamek.server.Server;

public abstract class AmmoBayWeapon
extends BayWeapon {
    private static final long serialVersionUID = 4718603486868464292L;

    public AttackHandler fire(WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        this.checkAmmo(weaponAttackAction, iGame);
        return super.fire(weaponAttackAction, iGame, server);
    }

    protected void checkAmmo(WeaponAttackAction weaponAttackAction, IGame iGame) {
        Entity entity = weaponAttackAction.getEntity(iGame);
        Mounted mounted = entity.getEquipment(weaponAttackAction.getWeaponId());
        for (int n : mounted.getBayWeapons()) {
            Mounted mounted2 = entity.getEquipment(n);
            Mounted mounted3 = mounted2.getLinked();
            if (mounted3 != null && mounted3.getShotsLeft() >= 1) continue;
            entity.loadWeaponWithSameAmmo(mounted2);
            mounted3 = mounted2.getLinked();
        }
    }

    protected AttackHandler getCorrectHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        return new AmmoBayWeaponHandler(toHitData, weaponAttackAction, iGame, server);
    }
}

