/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.deprecation;

import java.util.HashSet;
import java.util.Set;
import org.gradle.internal.deprecation.Deprecatable;
import org.gradle.internal.featurelifecycle.LoggingDeprecatedFeatureHandler;
import org.gradle.util.DeprecationLogger;

public class LoggingDeprecatable
implements Deprecatable {
    private final Set<String> deprecations = new HashSet<String>();

    @Override
    public void addDeprecation(String deprecation) {
        this.deprecations.add(deprecation);
    }

    @Override
    public Set<String> getDeprecations() {
        return this.deprecations;
    }

    @Override
    public void checkDeprecation() {
        String suffix = LoggingDeprecatedFeatureHandler.getRemovalDetails();
        for (String deprecation : this.deprecations) {
            DeprecationLogger.nagUserWithDeprecatedBuildInvocationFeature((String)deprecation, (String)String.format("This %s", suffix), null);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoggingDeprecatable that = (LoggingDeprecatable)o;
        return this.deprecations != null ? this.deprecations.equals(that.deprecations) : that.deprecations == null;
    }

    public int hashCode() {
        return this.deprecations != null ? this.deprecations.hashCode() : 0;
    }
}

