/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;

public class JsFirstExpressionVisitor
extends RecursiveJsVisitor {
    private boolean needsParentheses = false;

    public static boolean exec(JsExpressionStatement statement2) {
        JsExpression expression2 = statement2.getExpression();
        if (expression2 instanceof JsFunction) {
            return false;
        }
        JsFirstExpressionVisitor visitor2 = new JsFirstExpressionVisitor();
        visitor2.accept(statement2.getExpression());
        return visitor2.needsParentheses;
    }

    private JsFirstExpressionVisitor() {
    }

    @Override
    public void visitArrayAccess(@NotNull JsArrayAccess x) {
        this.accept(x.getArrayExpression());
    }

    @Override
    public void visitArray(@NotNull JsArrayLiteral x) {
    }

    @Override
    public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
        this.accept(x.getArg1());
    }

    @Override
    public void visitConditional(@NotNull JsConditional x) {
        this.accept(x.getTestExpression());
    }

    @Override
    public void visitFunction(@NotNull JsFunction x) {
        this.needsParentheses = true;
    }

    @Override
    public void visitInvocation(@NotNull JsInvocation invocation) {
        this.accept(invocation.getQualifier());
    }

    @Override
    public void visitNameRef(@NotNull JsNameRef nameRef) {
        if (!nameRef.isLeaf()) {
            this.accept(nameRef.getQualifier());
        }
    }

    @Override
    public void visitNew(@NotNull JsNew x) {
    }

    @Override
    public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
        this.needsParentheses = true;
    }

    @Override
    public void visitPostfixOperation(@NotNull JsPostfixOperation x) {
        this.accept(x.getArg());
    }

    @Override
    public void visitPrefixOperation(@NotNull JsPrefixOperation x) {
    }
}

