/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class NewContainerDialog
extends StatusDialog {
    private StringDialogField fContainerDialogField;
    private StatusInfo fContainerFieldStatus;
    private IFolder fFolder;
    private IPath[] fExistingFolders;
    private IProject fCurrProject;

    public NewContainerDialog(Shell parent, String title, IProject project, IPath[] existingFolders, CPListElement entryToEdit) {
        super(parent);
        this.setTitle(title);
        this.fContainerFieldStatus = new StatusInfo();
        SourceContainerAdapter adapter = new SourceContainerAdapter();
        this.fContainerDialogField = new StringDialogField();
        this.fContainerDialogField.setDialogFieldListener(adapter);
        this.fFolder = null;
        this.fExistingFolders = existingFolders;
        this.fCurrProject = project;
        if (entryToEdit == null) {
            this.fContainerDialogField.setText("");
        } else {
            this.fContainerDialogField.setText(entryToEdit.getPath().removeFirstSegments(1).toString());
        }
    }

    public void setMessage(String message) {
        this.fContainerDialogField.setLabelText(message);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        int widthHint = this.convertWidthInCharsToPixels(80);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        inner.setLayout((Layout)layout);
        this.fContainerDialogField.doFillIntoGrid(inner, 2);
        LayoutUtil.setWidthHint((Control)this.fContainerDialogField.getLabelControl(null), widthHint);
        LayoutUtil.setWidthHint((Control)this.fContainerDialogField.getTextControl(null), widthHint);
        LayoutUtil.setHorizontalGrabbing((Control)this.fContainerDialogField.getTextControl(null));
        this.fContainerDialogField.postSetFocusOnDialogField(parent.getDisplay());
        NewContainerDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void doStatusLineUpdate() {
        this.checkIfPathValid();
        this.updateStatus(this.fContainerFieldStatus);
    }

    protected void checkIfPathValid() {
        this.fFolder = null;
        String pathStr = this.fContainerDialogField.getText();
        if (pathStr.length() == 0) {
            this.fContainerFieldStatus.setError(NewWizardMessages.getString("NewContainerDialog.error.enterpath"));
            return;
        }
        IPath path = this.fCurrProject.getFullPath().append(pathStr);
        IWorkspace workspace = this.fCurrProject.getWorkspace();
        IStatus pathValidation = workspace.validatePath(path.toString(), 2);
        if (!pathValidation.isOK()) {
            this.fContainerFieldStatus.setError(NewWizardMessages.getFormattedString("NewContainerDialog.error.invalidpath", pathValidation.getMessage()));
            return;
        }
        IFolder folder = this.fCurrProject.getFolder(pathStr);
        if (this.isFolderExisting(folder)) {
            this.fContainerFieldStatus.setError(NewWizardMessages.getString("NewContainerDialog.error.pathexists"));
            return;
        }
        this.fContainerFieldStatus.setOK();
        this.fFolder = folder;
    }

    private boolean isFolderExisting(IFolder folder) {
        for (int i = 0; i < this.fExistingFolders.length; ++i) {
            if (!folder.getFullPath().equals(this.fExistingFolders[i])) continue;
            return true;
        }
        return false;
    }

    public IFolder getFolder() {
        return this.fFolder;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.jdt.ui.new_container_dialog_context");
    }

    private class SourceContainerAdapter
    implements IDialogFieldListener {
        private SourceContainerAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            NewContainerDialog.this.doStatusLineUpdate();
        }
    }
}

