/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.parts;

import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.pde.internal.ui.parts.SharedPartWithButtons;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class StructuredViewerPart
extends SharedPartWithButtons {
    private StructuredViewer viewer;
    private Point minSize = null;

    public StructuredViewerPart(String[] buttonLabels) {
        super(buttonLabels);
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    protected void createMainControl(Composite parent, int style, int span, FormToolkit toolkit) {
        this.viewer = this.createStructuredViewer(parent, style, toolkit);
        Control control = this.viewer.getControl();
        GridData gd = new GridData(1808);
        gd.horizontalSpan = span;
        control.setLayoutData((Object)gd);
        this.applyMinimumSize();
    }

    public void setMinimumSize(int width, int height) {
        this.minSize = new Point(width, height);
        if (this.viewer != null) {
            this.applyMinimumSize();
        }
    }

    private void applyMinimumSize() {
        if (this.minSize != null) {
            GridData gd = (GridData)this.viewer.getControl().getLayoutData();
            gd.widthHint = this.minSize.x;
            gd.heightHint = this.minSize.y;
        }
    }

    protected void updateEnabledState() {
        this.getControl().setEnabled(this.isEnabled());
        super.updateEnabledState();
    }

    protected abstract StructuredViewer createStructuredViewer(Composite var1, int var2, FormToolkit var3);
}

