/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public abstract class Refactoring
extends PlatformObject {
    private Object fValidationContext;

    public final void setValidationContext(Object context) {
        this.fValidationContext = context;
    }

    public final Object getValidationContext() {
        return this.fValidationContext;
    }

    public abstract String getName();

    public RefactoringStatus checkAllConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.beginTask("", 11);
        RefactoringStatus result = new RefactoringStatus();
        result.merge(this.checkInitialConditions((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        if (!result.hasFatalError()) {
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            result.merge(this.checkFinalConditions((IProgressMonitor)new SubProgressMonitor(pm, 10)));
        }
        pm.done();
        return result;
    }

    public abstract RefactoringStatus checkInitialConditions(IProgressMonitor var1) throws CoreException, OperationCanceledException;

    public abstract RefactoringStatus checkFinalConditions(IProgressMonitor var1) throws CoreException, OperationCanceledException;

    public abstract Change createChange(IProgressMonitor var1) throws CoreException, OperationCanceledException;

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance((Object)this)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public String toString() {
        return this.getName();
    }
}

