/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.schema;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaDescriptor;
import org.eclipse.pde.internal.core.schema.AbstractSchemaDescriptor;
import org.eclipse.pde.internal.core.schema.DevelopmentSchemaDescriptor;
import org.eclipse.pde.internal.core.schema.ExternalSchemaDescriptor;
import org.eclipse.pde.internal.core.schema.FileSchemaDescriptor;
import org.eclipse.pde.internal.core.schema.IncludedSchemaDescriptor;

public class SchemaRegistry
implements IModelProviderListener,
IResourceChangeListener,
IResourceDeltaVisitor {
    public static final String PLUGIN_POINT = "schemaMap";
    public static final String TAG_MAP = "map";
    private Hashtable workspaceDescriptors;
    private Hashtable externalDescriptors;
    private Vector dirtyWorkspaceModels;

    private void addExtensionPoint(IFile file) {
        IProject project = file.getProject();
        IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(project);
        if (model == null) {
            return;
        }
        IPluginExtensionPoint[] points = model.getPluginBase().getExtensionPoints();
        if (points.length == 0) {
            return;
        }
        for (int i = 0; i < points.length; ++i) {
            IPluginExtensionPoint point = points[i];
            IPath path = project.getFullPath();
            String schemaArg = point.getSchema();
            if (schemaArg == null) continue;
            path = path.append(schemaArg);
            IFile schemaFile = file.getWorkspace().getRoot().getFile(path);
            if (!file.equals(schemaFile)) continue;
            FileSchemaDescriptor sd = new FileSchemaDescriptor(file);
            this.workspaceDescriptors.put(point.getFullId(), sd);
            return;
        }
    }

    private AbstractSchemaDescriptor getSchemaDescriptor(String extensionPointId) {
        this.ensureCurrent();
        AbstractSchemaDescriptor descriptor = (AbstractSchemaDescriptor)this.workspaceDescriptors.get(extensionPointId);
        if (descriptor == null) {
            descriptor = (AbstractSchemaDescriptor)this.externalDescriptors.get(extensionPointId);
        }
        if (descriptor != null && descriptor.isEnabled()) {
            return descriptor;
        }
        return null;
    }

    private void ensureCurrent() {
        if (this.workspaceDescriptors == null) {
            this.initializeDescriptors();
        }
        if (this.dirtyWorkspaceModels != null && this.dirtyWorkspaceModels.size() > 0) {
            this.updateWorkspaceDescriptors();
        }
    }

    public ISchema getSchema(String extensionPointId) {
        AbstractSchemaDescriptor descriptor = this.getSchemaDescriptor(extensionPointId);
        if (descriptor == null) {
            return null;
        }
        return descriptor.getSchema();
    }

    public ISchema getIncludedSchema(ISchemaDescriptor parent, String schemaLocation) {
        this.ensureCurrent();
        Hashtable descriptors = null;
        if (parent instanceof FileSchemaDescriptor) {
            descriptors = this.workspaceDescriptors;
        } else if (parent instanceof ExternalSchemaDescriptor) {
            descriptors = this.externalDescriptors;
        }
        if (descriptors == null) {
            return null;
        }
        try {
            URL url = IncludedSchemaDescriptor.computeURL(parent, parent.getSchemaURL(), schemaLocation);
            String key = url.toString();
            ISchemaDescriptor desc = (ISchemaDescriptor)descriptors.get(key);
            if (desc == null) {
                desc = new IncludedSchemaDescriptor(parent, schemaLocation);
                descriptors.put(key, desc);
            }
            return desc.getSchema();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private void initializeDescriptors() {
        this.workspaceDescriptors = new Hashtable();
        this.externalDescriptors = new Hashtable();
        this.loadWorkspaceDescriptors();
        this.loadExternalDescriptors();
        PDECore.getDefault().getWorkspaceModelManager().addModelProviderListener(this);
        PDECore.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    private void loadExternalDescriptors() {
        ExternalModelManager registry = PDECore.getDefault().getExternalModelManager();
        IPluginModelBase[] models = registry.getAllModels();
        for (int i = 0; i < models.length; ++i) {
            IPluginExtensionPoint[] points = models[i].getPluginBase().getExtensionPoints();
            for (int j = 0; j < points.length; ++j) {
                IPluginExtensionPoint point = points[j];
                if (point.getSchema() == null) continue;
                ExternalSchemaDescriptor desc = new ExternalSchemaDescriptor(point);
                this.externalDescriptors.put(point.getFullId(), desc);
            }
        }
    }

    private void loadWorkspaceDescriptor(IPluginModelBase model) {
        IPluginBase pluginInfo = model.getPluginBase();
        IPluginExtensionPoint[] points = pluginInfo.getExtensionPoints();
        for (int j = 0; j < points.length; ++j) {
            DevelopmentSchemaDescriptor desc;
            IPluginExtensionPoint point = points[j];
            if (point.getSchema() == null) continue;
            Object schemaFile = this.getSchemaFile(point);
            if (schemaFile instanceof IFile) {
                desc = new FileSchemaDescriptor((IFile)schemaFile);
                this.workspaceDescriptors.put(point.getFullId(), desc);
                continue;
            }
            if (!(schemaFile instanceof File)) continue;
            desc = new ExternalSchemaDescriptor((File)schemaFile, point.getFullId(), true);
            this.workspaceDescriptors.put(point.getFullId(), desc);
        }
    }

    private void loadWorkspaceDescriptors() {
        WorkspaceModelManager manager = PDECore.getDefault().getWorkspaceModelManager();
        IPluginModel[] models = manager.getPluginModels();
        for (int i = 0; i < models.length; ++i) {
            IPluginModel model = models[i];
            this.loadWorkspaceDescriptor(model);
        }
        IFragmentModel[] fmodels = manager.getFragmentModels();
        for (int i = 0; i < fmodels.length; ++i) {
            IFragmentModel fmodel = fmodels[i];
            this.loadWorkspaceDescriptor(fmodel);
        }
    }

    private void loadWorkspaceDescriptors(IPluginModelBase model) {
        IPluginBase pluginInfo = model.getPluginBase();
        IPluginExtensionPoint[] points = pluginInfo.getExtensionPoints();
        for (int j = 0; j < points.length; ++j) {
            DevelopmentSchemaDescriptor desc;
            IPluginExtensionPoint point = points[j];
            if (point.getSchema() == null) continue;
            Object schemaFile = this.getSchemaFile(point);
            if (schemaFile instanceof IFile) {
                desc = new FileSchemaDescriptor((IFile)schemaFile);
                this.workspaceDescriptors.put(point.getFullId(), desc);
                continue;
            }
            if (!(schemaFile instanceof File)) continue;
            desc = new ExternalSchemaDescriptor((File)schemaFile, point.getFullId(), true);
            this.workspaceDescriptors.put(point.getFullId(), desc);
        }
    }

    private Object getSchemaFile(IPluginExtensionPoint point) {
        if (point.getSchema() == null) {
            return null;
        }
        IPluginModelBase model = point.getPluginModel();
        IFile pluginFile = (IFile)model.getUnderlyingResource();
        IPath path = pluginFile.getProject().getFullPath();
        path = path.append(point.getSchema());
        IFile schemaFile = pluginFile.getWorkspace().getRoot().getFile(path);
        if (schemaFile.exists()) {
            return schemaFile;
        }
        SourceLocationManager sourceManager = PDECore.getDefault().getSourceLocationManager();
        return sourceManager.findSourceFile(model.getPluginBase(), (IPath)new Path(point.getSchema()));
    }

    public void modelsChanged(IModelProviderEvent e) {
        IModel model;
        int i;
        int type = e.getEventTypes();
        if ((type & 1) != 0) {
            IModel[] added = e.getAddedModels();
            for (i = 0; i < added.length; ++i) {
                model = added[i];
                if (!(model instanceof IPluginModelBase)) continue;
                this.loadWorkspaceDescriptors((IPluginModelBase)model);
            }
        }
        if ((type & 2) != 0) {
            IModel[] removed = e.getRemovedModels();
            for (i = 0; i < removed.length; ++i) {
                model = removed[i];
                if (!(model instanceof IPluginModelBase)) continue;
                this.removeWorkspaceDescriptors((IPluginModelBase)model);
            }
        }
        if ((type & 4) != 0) {
            IModel[] changed = e.getChangedModels();
            if (this.dirtyWorkspaceModels == null) {
                this.dirtyWorkspaceModels = new Vector();
            }
            for (i = 0; i < changed.length; ++i) {
                model = changed[i];
                if (!(model instanceof IPluginModelBase)) continue;
                this.dirtyWorkspaceModels.add((IPluginModelBase)model);
            }
        }
    }

    private void removeExtensionPoint(IFile file) {
        Enumeration enumeration = this.workspaceDescriptors.keys();
        while (enumeration.hasMoreElements()) {
            IncludedSchemaDescriptor id;
            FileSchemaDescriptor fd;
            String key = (String)enumeration.nextElement();
            Object desc = this.workspaceDescriptors.get(key);
            if (desc instanceof FileSchemaDescriptor && (fd = (FileSchemaDescriptor)desc).getFile().equals(file)) {
                this.workspaceDescriptors.remove(key);
                fd.dispose();
                return;
            }
            if (!(desc instanceof IncludedSchemaDescriptor) || !file.equals((id = (IncludedSchemaDescriptor)desc).getFile())) continue;
            this.workspaceDescriptors.remove(key);
            id.dispose();
            return;
        }
    }

    private void removeWorkspaceDescriptors(IPluginModelBase model) {
        IPluginBase pluginInfo = model.getPluginBase();
        IProject project = model.getUnderlyingResource().getProject();
        IPluginExtensionPoint[] points = pluginInfo.getExtensionPoints();
        for (int i = 0; i < points.length; ++i) {
            FileSchemaDescriptor desc;
            IFile schemaFile;
            IPluginExtensionPoint point = points[i];
            Object descObj = this.workspaceDescriptors.get(point.getFullId());
            if (descObj == null || !(descObj instanceof FileSchemaDescriptor) || !project.equals((schemaFile = (desc = (FileSchemaDescriptor)descObj).getFile()).getProject())) continue;
            this.workspaceDescriptors.remove(point.getFullId());
        }
        Enumeration enumeration = this.workspaceDescriptors.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            Object desc = this.workspaceDescriptors.get(key);
            if (!(desc instanceof IncludedSchemaDescriptor)) continue;
            IncludedSchemaDescriptor id = (IncludedSchemaDescriptor)desc;
            IFile file = id.getFile();
            if (file != null && file.getProject().equals(project)) {
                this.workspaceDescriptors.remove(key);
            }
            id.dispose();
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta;
        if (event.getType() == 1 && (delta = event.getDelta()) != null) {
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException e) {
                PDECore.logException(e);
            }
        }
    }

    public void shutdown() {
        if (this.workspaceDescriptors == null) {
            return;
        }
        this.disposeDescriptors(this.workspaceDescriptors);
        this.disposeDescriptors(this.externalDescriptors);
        this.workspaceDescriptors = null;
        this.externalDescriptors = null;
        this.dirtyWorkspaceModels = null;
        PDECore.getDefault().getWorkspaceModelManager().removeModelProviderListener(this);
        PDECore.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    private void disposeDescriptors(Hashtable descriptors) {
        Iterator iter = descriptors.values().iterator();
        while (iter.hasNext()) {
            AbstractSchemaDescriptor desc = (AbstractSchemaDescriptor)iter.next();
            desc.dispose();
        }
        descriptors.clear();
    }

    private void updateExtensionPoint(IFile file) {
        Iterator iter = this.workspaceDescriptors.values().iterator();
        while (iter.hasNext()) {
            AbstractSchemaDescriptor sd = (AbstractSchemaDescriptor)iter.next();
            IFile schemaFile = null;
            if (sd instanceof FileSchemaDescriptor) {
                schemaFile = ((FileSchemaDescriptor)sd).getFile();
            } else if (sd instanceof IncludedSchemaDescriptor) {
                schemaFile = ((IncludedSchemaDescriptor)sd).getFile();
            }
            if (schemaFile == null || !schemaFile.equals(file)) continue;
            sd.dispose();
            break;
        }
    }

    private void updateWorkspaceDescriptors() {
        for (int i = 0; i < this.dirtyWorkspaceModels.size(); ++i) {
            IPluginModelBase model = (IPluginModelBase)this.dirtyWorkspaceModels.elementAt(i);
            this.updateWorkspaceDescriptors(model);
        }
        this.dirtyWorkspaceModels.clear();
    }

    private void updateWorkspaceDescriptors(IPluginModelBase model) {
        this.removeWorkspaceDescriptors(model);
        this.loadWorkspaceDescriptors(model);
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            String fileName = file.getName().toLowerCase();
            if (!fileName.endsWith(".exsd") && !fileName.endsWith(".mxsd")) {
                return true;
            }
            if (!WorkspaceModelManager.isPluginProject(file.getProject())) {
                return true;
            }
            if (delta.getKind() == 4) {
                if ((0x100 & delta.getFlags()) != 0) {
                    this.updateExtensionPoint(file);
                }
            } else if (delta.getKind() == 1) {
                this.addExtensionPoint(file);
            } else if (delta.getKind() == 2) {
                this.removeExtensionPoint(file);
            }
        }
        return true;
    }
}

