/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.codeassist.IExtendedCompletionRequestor;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.NameLookup;

public class CompletionRequestorWrapper
implements IExtendedCompletionRequestor {
    private static Object NO_ATTACHED_SOURCE = new Object();
    static final char[] ARG = "arg".toCharArray();
    static final char[] ARG0 = "arg0".toCharArray();
    static final char[] ARG1 = "arg1".toCharArray();
    static final char[] ARG2 = "arg2".toCharArray();
    static final char[] ARG3 = "arg3".toCharArray();
    static final char[][] ARGS1 = new char[][]{ARG0};
    static final char[][] ARGS2 = new char[][]{ARG0, ARG1};
    static final char[][] ARGS3 = new char[][]{ARG0, ARG1, ARG2};
    static final char[][] ARGS4 = new char[][]{ARG0, ARG1, ARG2, ARG3};
    public CompletionEngine completionEngine;
    ICompletionRequestor clientRequestor;
    NameLookup nameLookup;

    public CompletionRequestorWrapper(ICompletionRequestor clientRequestor, NameLookup nameLookup) {
        this.clientRequestor = clientRequestor;
        this.nameLookup = nameLookup;
    }

    public void acceptAnonymousType(char[] superTypePackageName, char[] superTypeName, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
        if (parameterNames == null) {
            parameterNames = this.findMethodParameterNames(superTypePackageName, superTypeName, superTypeName, parameterPackageNames, parameterTypeNames);
        }
        if (CompletionEngine.DEBUG) {
            this.printDebug("acceptAnonymousType", new String[]{String.valueOf(superTypePackageName), String.valueOf(superTypeName), String.valueOf(parameterPackageNames), String.valueOf(parameterTypeNames), String.valueOf(parameterNames), String.valueOf(completionName), String.valueOf(modifiers), String.valueOf(completionStart), String.valueOf(completionEnd), String.valueOf(relevance)});
        }
        this.clientRequestor.acceptAnonymousType(superTypePackageName, superTypeName, parameterPackageNames, parameterTypeNames, parameterNames, completionName, modifiers, completionStart, completionEnd, relevance);
    }

    public void acceptClass(char[] packageName, char[] className, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
        if (CompletionEngine.DEBUG) {
            this.printDebug("acceptClass", new String[]{String.valueOf(packageName), String.valueOf(className), String.valueOf(completionName), String.valueOf(modifiers), String.valueOf(completionStart), String.valueOf(completionEnd), String.valueOf(relevance)});
        }
        this.clientRequestor.acceptClass(packageName, className, completionName, modifiers, completionStart, completionEnd, relevance);
    }

    public void acceptError(IProblem error) {
        if (CompletionEngine.DEBUG) {
            System.out.print("COMPLETION - acceptError(");
            System.out.print(error);
            System.out.println(")");
        }
        this.clientRequestor.acceptError(error);
    }

    public void acceptField(char[] declaringTypePackageName, char[] declaringTypeName, char[] name, char[] typePackageName, char[] typeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
        if (CompletionEngine.DEBUG) {
            this.printDebug("acceptField", new String[]{String.valueOf(declaringTypePackageName), String.valueOf(declaringTypeName), String.valueOf(name), String.valueOf(typePackageName), String.valueOf(typeName), String.valueOf(completionName), String.valueOf(modifiers), String.valueOf(completionStart), String.valueOf(completionEnd), String.valueOf(relevance)});
        }
        this.clientRequestor.acceptField(declaringTypePackageName, declaringTypeName, name, typePackageName, typeName, completionName, modifiers, completionStart, completionEnd, relevance);
    }

    public void acceptInterface(char[] packageName, char[] interfaceName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
        if (CompletionEngine.DEBUG) {
            this.printDebug("acceptInterface", new String[]{String.valueOf(packageName), String.valueOf(interfaceName), String.valueOf(completionName), String.valueOf(modifiers), String.valueOf(completionStart), String.valueOf(completionEnd), String.valueOf(relevance)});
        }
        this.clientRequestor.acceptInterface(packageName, interfaceName, completionName, modifiers, completionStart, completionEnd, relevance);
    }

    public void acceptKeyword(char[] keywordName, int completionStart, int completionEnd, int relevance) {
        if (CompletionEngine.DEBUG) {
            this.printDebug("acceptKeyword", new String[]{String.valueOf(keywordName), String.valueOf(completionStart), String.valueOf(completionEnd), String.valueOf(relevance)});
        }
        this.clientRequestor.acceptKeyword(keywordName, completionStart, completionEnd, relevance);
    }

    public void acceptLabel(char[] labelName, int completionStart, int completionEnd, int relevance) {
        if (CompletionEngine.DEBUG) {
            this.printDebug("acceptLabel", new String[]{String.valueOf(labelName), String.valueOf(completionStart), String.valueOf(completionEnd), String.valueOf(relevance)});
        }
        this.clientRequestor.acceptLabel(labelName, completionStart, completionEnd, relevance);
    }

    public void acceptLocalVariable(char[] name, char[] typePackageName, char[] typeName, int modifiers, int completionStart, int completionEnd, int relevance) {
        if (CompletionEngine.DEBUG) {
            this.printDebug("acceptLocalVariable", new String[]{String.valueOf(name), String.valueOf(typePackageName), String.valueOf(typeName), String.valueOf(modifiers), String.valueOf(completionStart), String.valueOf(completionEnd), String.valueOf(relevance)});
        }
        this.clientRequestor.acceptLocalVariable(name, typePackageName, typeName, modifiers, completionStart, completionEnd, relevance);
    }

    public void acceptMethod(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypePackageName, char[] returnTypeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
        if (parameterNames == null) {
            parameterNames = this.findMethodParameterNames(declaringTypePackageName, declaringTypeName, selector, parameterPackageNames, parameterTypeNames);
        }
        if (CompletionEngine.DEBUG) {
            this.printDebug("acceptMethod", new String[]{String.valueOf(declaringTypePackageName), String.valueOf(declaringTypeName), String.valueOf(selector), String.valueOf(parameterPackageNames), String.valueOf(parameterTypeNames), String.valueOf(parameterNames), String.valueOf(returnTypePackageName), String.valueOf(returnTypeName), String.valueOf(completionName), String.valueOf(modifiers), String.valueOf(completionStart), String.valueOf(completionEnd), String.valueOf(relevance)});
        }
        this.clientRequestor.acceptMethod(declaringTypePackageName, declaringTypeName, selector, parameterPackageNames, parameterTypeNames, parameterNames, returnTypePackageName, returnTypeName, completionName, modifiers, completionStart, completionEnd, relevance);
    }

    public void acceptMethodDeclaration(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypePackageName, char[] returnTypeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
        if (parameterNames == null) {
            int length = parameterTypeNames.length;
            parameterNames = this.findMethodParameterNames(declaringTypePackageName, declaringTypeName, selector, parameterPackageNames, parameterTypeNames);
            StringBuffer completion = new StringBuffer(completionName.length);
            int start = 0;
            int end = CharOperation.indexOf('%', completionName);
            completion.append(CharOperation.subarray(completionName, start, end));
            for (int i = 0; i < length; ++i) {
                completion.append(parameterNames[i]);
                start = end + 1;
                end = CharOperation.indexOf('%', completionName, start);
                if (end > -1) {
                    completion.append(CharOperation.subarray(completionName, start, end));
                    continue;
                }
                completion.append(CharOperation.subarray(completionName, start, completionName.length));
            }
            completionName = completion.toString().toCharArray();
        }
        if (CompletionEngine.DEBUG) {
            this.printDebug("acceptMethodDeclaration", new String[]{String.valueOf(declaringTypePackageName), String.valueOf(declaringTypeName), String.valueOf(selector), String.valueOf(parameterPackageNames), String.valueOf(parameterTypeNames), String.valueOf(parameterNames), String.valueOf(returnTypePackageName), String.valueOf(returnTypeName), String.valueOf(completionName), String.valueOf(modifiers), String.valueOf(completionStart), String.valueOf(completionEnd), String.valueOf(relevance)});
        }
        this.clientRequestor.acceptMethodDeclaration(declaringTypePackageName, declaringTypeName, selector, parameterPackageNames, parameterTypeNames, parameterNames, returnTypePackageName, returnTypeName, completionName, modifiers, completionStart, completionEnd, relevance);
    }

    public void acceptModifier(char[] modifierName, int completionStart, int completionEnd, int relevance) {
        if (CompletionEngine.DEBUG) {
            this.printDebug("acceptModifier", new String[]{String.valueOf(modifierName), String.valueOf(completionStart), String.valueOf(completionEnd), String.valueOf(relevance)});
        }
        this.clientRequestor.acceptModifier(modifierName, completionStart, completionEnd, relevance);
    }

    public void acceptPackage(char[] packageName, char[] completionName, int completionStart, int completionEnd, int relevance) {
        if (CompletionEngine.DEBUG) {
            this.printDebug("acceptPackage", new String[]{String.valueOf(packageName), String.valueOf(completionName), String.valueOf(completionStart), String.valueOf(completionEnd), String.valueOf(relevance)});
        }
        this.clientRequestor.acceptPackage(packageName, completionName, completionStart, completionEnd, relevance);
    }

    public void acceptType(char[] packageName, char[] typeName, char[] completionName, int completionStart, int completionEnd, int relevance) {
        if (CompletionEngine.DEBUG) {
            this.printDebug("acceptType", new String[]{String.valueOf(packageName), String.valueOf(typeName), String.valueOf(completionName), String.valueOf(completionStart), String.valueOf(completionEnd), String.valueOf(relevance)});
        }
        this.clientRequestor.acceptType(packageName, typeName, completionName, completionStart, completionEnd, relevance);
    }

    public void acceptVariableName(char[] typePackageName, char[] typeName, char[] name, char[] completionName, int completionStart, int completionEnd, int relevance) {
        if (CompletionEngine.DEBUG) {
            this.printDebug("acceptVariableName", new String[]{String.valueOf(typePackageName), String.valueOf(typeName), String.valueOf(name), String.valueOf(completionName), String.valueOf(completionStart), String.valueOf(completionEnd), String.valueOf(relevance)});
        }
        this.clientRequestor.acceptVariableName(typePackageName, typeName, name, completionName, completionStart, completionEnd, relevance);
    }

    private char[][] findMethodParameterNames(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames) {
        Object parameterNames = null;
        int length = parameterTypeNames.length;
        char[] typeName = CharOperation.concat(declaringTypePackageName, declaringTypeName, '.');
        Object cachedType = this.completionEngine.typeCache.get(typeName);
        IType type = null;
        if (cachedType != null) {
            if (cachedType != NO_ATTACHED_SOURCE && cachedType instanceof BinaryType) {
                type = (BinaryType)cachedType;
            }
        } else {
            type = this.nameLookup.findType(new String(typeName), false, 0);
            if (type instanceof BinaryType) {
                if (((JavaElement)((Object)type)).getSourceMapper() != null) {
                    this.completionEngine.typeCache.put(typeName, type);
                } else {
                    this.completionEngine.typeCache.put(typeName, NO_ATTACHED_SOURCE);
                    type = null;
                }
            } else {
                type = null;
            }
        }
        if (type != null) {
            String[] args = new String[length];
            for (int i = 0; i < length; ++i) {
                char[] parameterType = CharOperation.concat(parameterPackageNames[i], parameterTypeNames[i], '.');
                args[i] = Signature.createTypeSignature(parameterType, true);
            }
            IMethod method = type.getMethod(new String(selector), args);
            try {
                parameterNames = new char[length][];
                String[] params = method.getParameterNames();
                for (int i = 0; i < length; ++i) {
                    parameterNames[i] = params[i].toCharArray();
                }
            }
            catch (JavaModelException e) {
                parameterNames = null;
            }
        }
        if (parameterNames == null) {
            switch (length) {
                case 0: {
                    parameterNames = new char[length][];
                    break;
                }
                case 1: {
                    parameterNames = ARGS1;
                    break;
                }
                case 2: {
                    parameterNames = ARGS2;
                    break;
                }
                case 3: {
                    parameterNames = ARGS3;
                    break;
                }
                case 4: {
                    parameterNames = ARGS4;
                    break;
                }
                default: {
                    parameterNames = new char[length][];
                    for (int i = 0; i < length; ++i) {
                        parameterNames[i] = CharOperation.concat(ARG, String.valueOf(i).toCharArray());
                    }
                }
            }
        }
        return parameterNames;
    }

    public void acceptPotentialMethodDeclaration(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, int completionStart, int completionEnd, int relevance) {
        if (this.clientRequestor instanceof IExtendedCompletionRequestor) {
            if (CompletionEngine.DEBUG) {
                this.printDebug("acceptPotentialMethodDeclaration", new String[]{String.valueOf(declaringTypePackageName), String.valueOf(declaringTypeName), String.valueOf(selector), String.valueOf(completionStart), String.valueOf(completionEnd), String.valueOf(relevance)});
            }
            ((IExtendedCompletionRequestor)this.clientRequestor).acceptPotentialMethodDeclaration(declaringTypePackageName, declaringTypeName, selector, completionStart, completionEnd, relevance);
        }
    }

    private void printDebug(String header, String[] param) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("COMPLETION - ");
        buffer.append(header);
        buffer.append("(");
        for (int i = 0; i < param.length; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(param[i]);
        }
        buffer.append(")");
        System.out.println(buffer.toString());
    }
}

