/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.formatter;

import java.util.LinkedList;
import org.eclipse.ant.internal.ui.editor.formatter.FormattingPreferences;
import org.eclipse.ant.internal.ui.editor.formatter.XmlDocumentFormatter;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;

public class XmlDocumentFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final LinkedList fDocuments = new LinkedList();
    private FormattingPreferences prefs;
    private int indent = -1;

    public XmlDocumentFormattingStrategy() {
        this.prefs = new FormattingPreferences();
    }

    public XmlDocumentFormattingStrategy(FormattingPreferences prefs, int indent) {
        Assert.isNotNull((Object)prefs);
        this.prefs = prefs;
        this.indent = indent;
    }

    public void format() {
        super.format();
        IDocument document = (IDocument)this.fDocuments.removeFirst();
        if (document != null) {
            String formattedText;
            String documentText = document.get();
            XmlDocumentFormatter formatter = new XmlDocumentFormatter();
            if (this.indent != -1) {
                formatter.setInitialIndent(this.indent);
            }
            if ((formattedText = formatter.format(documentText, this.prefs)) != null && !formattedText.equals(documentText)) {
                document.set(formattedText);
            }
        }
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        this.fDocuments.addLast(context.getProperty((Object)"formatting.context.medium"));
    }

    public void formatterStops() {
        super.formatterStops();
        this.fDocuments.clear();
    }
}

