/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.ISyncInfoTreeChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSSyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteResource;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.RemoteLogOperation;
import org.eclipse.team.internal.ccvs.ui.subscriber.ChangeLogDiffNode;
import org.eclipse.team.internal.ccvs.ui.subscriber.ChangeLogModelSorter;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.ISynchronizeModelProviderDescriptor;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelProvider;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.progress.UIJob;

public class ChangeLogModelProvider
extends SynchronizeModelProvider {
    private RemoteLogOperation logOperation;
    private boolean shutdown = false;
    private FetchLogEntriesJob fetchLogEntriesJob;
    private ChangeLogActionGroup sortGroup;
    private CVSTag tag1;
    private CVSTag tag2;
    private Map multipleResourceMap;
    private static final String SORT_ORDER_GROUP = "changelog_sort";
    private static final String P_LAST_COMMENTSORT = "org.eclipse.team.ui.P_LAST_COMMENT_SORT";
    private static final String P_LAST_RESOURCESORT = "org.eclipse.team.ui.P_LAST_RESOURCE_SORT";
    private static final ChangeLogModelProviderDescriptor descriptor = new ChangeLogModelProviderDescriptor();

    public ChangeLogModelProvider(ISynchronizePageConfiguration configuration, SyncInfoSet set, CVSTag tag1, CVSTag tag2) {
        super(configuration, set);
        this.tag1 = tag1;
        this.tag2 = tag2;
        configuration.addMenuGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SORT_ORDER_GROUP);
        this.sortGroup = new ChangeLogActionGroup();
        configuration.addActionContribution((SynchronizePageActionGroup)this.sortGroup);
    }

    public ISynchronizeModelProviderDescriptor getDescriptor() {
        return descriptor;
    }

    protected IDiffElement[] buildModelObjects(ISynchronizeModelElement node) {
        if (node == this.getModelRoot()) {
            try {
                if (this.fetchLogEntriesJob != null && this.fetchLogEntriesJob.getState() != 0) {
                    this.fetchLogEntriesJob.cancel();
                    this.fetchLogEntriesJob.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.startUpdateJob(this.getSyncInfoSet());
        }
        return new IDiffElement[0];
    }

    private void startUpdateJob(SyncInfoSet set) {
        if (this.fetchLogEntriesJob == null) {
            this.fetchLogEntriesJob = new FetchLogEntriesJob();
        }
        this.fetchLogEntriesJob.add(set);
    }

    private void refreshViewer() {
        UIJob updateUI = new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        StructuredViewer tree = 1.access$300(this.this$1).getViewer();
                        tree.refresh();
                        ISynchronizeModelElement root = 1.access$300(this.this$1).getModelRoot();
                        if (root instanceof SynchronizeModelElement) {
                            ((SynchronizeModelElement)root).fireChanges();
                        }
                    }
                });
                return Status.OK_STATUS;
            }

            static /* synthetic */ ChangeLogModelProvider access$300(1 x0) {
                return x0.ChangeLogModelProvider.this;
            }
        };
        updateUI.setSystem(true);
        updateUI.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateRoots(SyncInfoSet set, IProgressMonitor monitor) {
        try {
            SyncInfo info;
            monitor.beginTask(null, 100);
            SyncInfo[] infos = set.getSyncInfos();
            ArrayList<SyncInfo> commentNodes = new ArrayList<SyncInfo>();
            ArrayList<SyncInfo> resourceNodes = new ArrayList<SyncInfo>();
            for (int i = 0; i < infos.length; ++i) {
                info = infos[i];
                if (this.isInterestingChange(info)) {
                    commentNodes.add(info);
                    continue;
                }
                resourceNodes.add(info);
            }
            Iterator it = resourceNodes.iterator();
            while (it.hasNext()) {
                info = (SyncInfo)it.next();
                this.addNewElementFor(info, null, null);
            }
            if (!resourceNodes.isEmpty()) {
                this.refreshViewer();
            }
            SyncInfo[] commentInfos = commentNodes.toArray(new SyncInfo[commentNodes.size()]);
            RemoteLogOperation logs = this.getSyncInfoComment(commentInfos, Policy.subMonitorFor(monitor, 80));
            this.addLogEntries(commentInfos, logs, Policy.subMonitorFor(monitor, 20));
        }
        catch (CVSException e) {
            Utils.handle((Throwable)e);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLogEntries(SyncInfo[] commentInfos, RemoteLogOperation logs, IProgressMonitor monitor) {
        try {
            monitor.beginTask(null, commentInfos.length * 10);
            if (logs != null) {
                for (int i = 0; i < commentInfos.length; ++i) {
                    this.addSyncInfoToCommentNode(commentInfos[i], logs);
                    monitor.worked(10);
                }
                if (this.getConfiguration().getComparisonType().equals("two-way")) {
                    logs.clearEntries();
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private void addSyncInfoToCommentNode(SyncInfo info, RemoteLogOperation logs) {
        ICVSRemoteResource remoteResource = this.getRemoteResource((CVSSyncInfo)info);
        if (this.tag1 != null && this.tag2 != null) {
            this.addMultipleRevisions(info, logs, remoteResource);
        } else {
            this.addSingleRevision(info, logs, remoteResource);
        }
    }

    private void addMultipleRevisions(SyncInfo info, RemoteLogOperation logs, ICVSRemoteResource remoteResource) {
        ILogEntry[] logEntries = logs.getLogEntries(remoteResource);
        if (logEntries == null || logEntries.length == 0) {
            this.addNewElementFor(info, null, null);
        } else {
            for (int i = 0; i < logEntries.length; ++i) {
                ILogEntry entry = logEntries[i];
                this.addNewElementFor(info, remoteResource, entry);
            }
        }
    }

    private void addSingleRevision(SyncInfo info, RemoteLogOperation logs, ICVSRemoteResource remoteResource) {
        ILogEntry logEntry = logs.getLogEntry(remoteResource);
        try {
            String remoteRevision = ((ICVSRemoteFile)remoteResource).getRevision();
            if (this.isDeletedRemotely(info)) {
                ILogEntry[] logEntries = logs.getLogEntries(remoteResource);
                for (int i = 0; i < logEntries.length; ++i) {
                    ILogEntry entry = logEntries[i];
                    String revision = entry.getRevision();
                    if (!entry.isDeletion() || !ResourceSyncInfo.isLaterRevision((String)revision, (String)remoteRevision)) continue;
                    logEntry = entry;
                }
            }
        }
        catch (TeamException e) {
            // empty catch block
        }
        this.addNewElementFor(info, remoteResource, logEntry);
    }

    private boolean isDeletedRemotely(SyncInfo info) {
        int kind = info.getKind();
        if (kind == 10) {
            return true;
        }
        return SyncInfo.getDirection((int)kind) == 12 && info.getRemote() == null;
    }

    private void addNewElementFor(SyncInfo info, ICVSRemoteResource remoteResource, ILogEntry logEntry) {
        FullPathSyncInfoElement element;
        if (remoteResource != null && logEntry != null && this.isInterestingChange((SyncInfo)info)) {
            ChangeLogDiffNode changeRoot = this.getChangeLogDiffNodeFor(logEntry);
            if (changeRoot == null) {
                changeRoot = new ChangeLogDiffNode(this.getModelRoot(), logEntry);
                this.addToViewer((ISynchronizeModelElement)changeRoot);
            }
            if (this.requiresCustomSyncInfo((SyncInfo)info, remoteResource, logEntry)) {
                info = new CVSUpdatableSyncInfo(info.getKind(), info.getLocal(), info.getBase(), (IResourceVariant)((RemoteResource)logEntry.getRemoteFile()), ((CVSSyncInfo)info).getSubscriber());
                try {
                    info.init();
                }
                catch (TeamException e) {
                    // empty catch block
                }
            }
            element = new FullPathSyncInfoElement((IDiffContainer)changeRoot, (SyncInfo)info);
        } else {
            element = new FullPathSyncInfoElement((IDiffContainer)this.getModelRoot(), (SyncInfo)info);
        }
        this.addToViewer((ISynchronizeModelElement)element);
    }

    private boolean requiresCustomSyncInfo(SyncInfo info, ICVSRemoteResource remoteResource, ILogEntry logEntry) {
        if (logEntry.isDeletion() || !(info instanceof CVSSyncInfo)) {
            return false;
        }
        IResourceVariant remote = info.getRemote();
        if (remote == null) {
            return true;
        }
        return !remote.equals(remoteResource);
    }

    private ChangeLogDiffNode getChangeLogDiffNodeFor(ILogEntry entry) {
        IDiffElement[] elements = this.getModelRoot().getChildren();
        for (int i = 0; i < elements.length; ++i) {
            ChangeLogDiffNode other;
            ILogEntry thisLog;
            IDiffElement element = elements[i];
            if (!(element instanceof ChangeLogDiffNode) || !(thisLog = (other = (ChangeLogDiffNode)element).getComment()).getComment().equals(entry.getComment()) || !thisLog.getAuthor().equals(entry.getAuthor())) continue;
            return other;
        }
        return null;
    }

    private boolean isInterestingChange(SyncInfo info) {
        int kind = info.getKind();
        if (info.getLocal().getType() != 1) {
            return false;
        }
        if (info.getComparator().isThreeWay()) {
            return (kind & 0xC) != 4;
        }
        return true;
    }

    private RemoteLogOperation getSyncInfoComment(SyncInfo[] infos, IProgressMonitor monitor) throws CVSException, InterruptedException {
        ArrayList<ICVSRemoteResource> remotes = new ArrayList<ICVSRemoteResource>();
        for (int i = 0; i < infos.length; ++i) {
            ICVSRemoteResource remote;
            CVSSyncInfo info = (CVSSyncInfo)infos[i];
            if (info.getLocal().getType() != 1 || (remote = this.getRemoteResource(info)) == null) continue;
            remotes.add(remote);
        }
        ICVSRemoteResource[] remoteResources = remotes.toArray(new ICVSRemoteResource[remotes.size()]);
        if (this.logOperation == null) {
            this.logOperation = new RemoteLogOperation(null, remoteResources, this.tag1, this.tag2);
        }
        if (!remotes.isEmpty()) {
            this.logOperation.setRemoteResources(remoteResources);
            this.logOperation.execute(monitor);
        }
        return this.logOperation;
    }

    private ICVSRemoteResource getRemoteResource(CVSSyncInfo info) {
        try {
            ICVSRemoteResource remote = (ICVSRemoteResource)info.getRemote();
            ICVSRemoteFile local = (ICVSRemoteFile)CVSWorkspaceRoot.getRemoteResourceFor((IResource)info.getLocal());
            if (local == null) {
                local = (ICVSRemoteResource)info.getBase();
            }
            String remoteRevision = this.getRevisionString(remote);
            String localRevision = this.getRevisionString((ICVSRemoteResource)local);
            boolean useRemote = true;
            if (local != null && remote != null) {
                useRemote = ResourceSyncInfo.isLaterRevision((String)remoteRevision, (String)localRevision);
            } else if (remote == null) {
                useRemote = false;
            }
            if (useRemote) {
                return remote;
            }
            if (local != null) {
                return local;
            }
            return null;
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
            return null;
        }
    }

    private String getRevisionString(ICVSRemoteResource remoteFile) {
        if (remoteFile instanceof RemoteFile) {
            return ((RemoteFile)remoteFile).getRevision();
        }
        return null;
    }

    public void dispose() {
        this.shutdown = true;
        if (this.fetchLogEntriesJob != null && this.fetchLogEntriesJob.getState() != 0) {
            this.fetchLogEntriesJob.cancel();
        }
        this.sortGroup.dispose();
        super.dispose();
    }

    public ViewerSorter getViewerSorter() {
        int commentSort = 1;
        int resourceSort = 2;
        try {
            IDialogSettings pageSettings = this.getConfiguration().getSite().getPageSettings();
            if (pageSettings != null) {
                commentSort = pageSettings.getInt(P_LAST_COMMENTSORT);
                resourceSort = pageSettings.getInt(P_LAST_RESOURCESORT);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new ChangeLogModelSorter(commentSort, resourceSort);
    }

    protected void doAdd(ISynchronizeModelElement parent, ISynchronizeModelElement element) {
        AbstractTreeViewer viewer = (AbstractTreeViewer)this.getViewer();
        viewer.add((Object)parent, (Object)element);
    }

    protected void doRemove(ISynchronizeModelElement element) {
        AbstractTreeViewer viewer = (AbstractTreeViewer)this.getViewer();
        viewer.remove((Object)element);
    }

    protected void handleResourceAdditions(ISyncInfoTreeChangeEvent event) {
        this.startUpdateJob(new SyncInfoSet(event.getAddedResources()));
    }

    protected void handleResourceChanges(ISyncInfoTreeChangeEvent event) {
        SyncInfo[] infos = event.getChangedResources();
        for (int i = 0; i < infos.length; ++i) {
            SyncInfo info = infos[i];
            IResource local = info.getLocal();
            this.removeFromViewer(local);
        }
        this.startUpdateJob(new SyncInfoSet(event.getChangedResources()));
    }

    protected void handleResourceRemovals(ISyncInfoTreeChangeEvent event) {
        IResource[] removedRoots = event.getRemovedSubtreeRoots();
        for (int i = 0; i < removedRoots.length; ++i) {
            this.removeFromViewer(removedRoots[i]);
        }
        IResource[] removedResources = event.getRemovedResources();
        for (int i = 0; i < removedResources.length; ++i) {
            this.removeFromViewer(removedResources[i]);
        }
    }

    protected void removeFromViewer(IResource resource) {
        List elements;
        CVSSyncInfo info;
        ISynchronizeModelElement element;
        if (this.logOperation != null && (element = this.getModelObject(resource)) instanceof FullPathSyncInfoElement && (info = (CVSSyncInfo)((FullPathSyncInfoElement)element).getSyncInfo()) != null) {
            ICVSRemoteResource remote = this.getRemoteResource(info);
            this.logOperation.clearEntriesFor(remote);
        }
        if (this.multipleResourceMap != null && (elements = (List)this.multipleResourceMap.get(resource)) != null) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                ISynchronizeModelElement element2 = (ISynchronizeModelElement)it.next();
                super.removeFromViewer(element2);
            }
            this.multipleResourceMap.remove(resource);
        }
        super.removeFromViewer(resource);
    }

    protected void addToViewer(ISynchronizeModelElement node) {
        IResource r = node.getResource();
        if (r != null) {
            ArrayList<ISynchronizeModelElement> elements;
            if (this.multipleResourceMap == null) {
                this.multipleResourceMap = new HashMap(5);
            }
            if ((elements = (ArrayList<ISynchronizeModelElement>)this.multipleResourceMap.get(r)) == null) {
                elements = new ArrayList<ISynchronizeModelElement>(2);
                this.multipleResourceMap.put(r, elements);
            }
            elements.add(node);
        }
        super.addToViewer(node);
    }

    public static class ChangeLogModelProviderDescriptor
    implements ISynchronizeModelProviderDescriptor {
        public static final String ID = "org.eclipse.team.ui.modelprovider_cvs_changelog";

        public String getId() {
            return ID;
        }

        public String getName() {
            return Policy.bind("ChangeLogModelProvider.5");
        }

        public ImageDescriptor getImageDescriptor() {
            return CVSUIPlugin.getPlugin().getImageDescriptor("obj16/changelog_obj.gif");
        }
    }

    private class FetchLogEntriesJob
    extends Job {
        private Set syncSets = new HashSet();

        public FetchLogEntriesJob() {
            super(Policy.bind("ChangeLogModelProvider.4"));
            this.setUser(false);
        }

        public boolean belongsTo(Object family) {
            return family == ISynchronizeManager.FAMILY_SYNCHRONIZE_OPERATION;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            if (this.syncSets != null && !ChangeLogModelProvider.this.shutdown) {
                SyncInfoSet[] updates;
                Set set = this.syncSets;
                synchronized (set) {
                    updates = this.syncSets.toArray(new SyncInfoSet[this.syncSets.size()]);
                    this.syncSets.clear();
                }
                for (int i = 0; i < updates.length; ++i) {
                    ChangeLogModelProvider.this.calculateRoots(updates[i], monitor);
                }
                ChangeLogModelProvider.this.refreshViewer();
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(SyncInfoSet set) {
            Set set2 = this.syncSets;
            synchronized (set2) {
                this.syncSets.add(set);
            }
            this.schedule();
        }

        public boolean shouldRun() {
            return !this.syncSets.isEmpty();
        }
    }

    public class CVSUpdatableSyncInfo
    extends CVSSyncInfo {
        public int kind;

        public CVSUpdatableSyncInfo(int kind, IResource local, IResourceVariant base, IResourceVariant remote, Subscriber s) {
            super(local, base, remote, s);
            this.kind = kind;
        }

        protected int calculateKind() throws TeamException {
            return this.kind;
        }
    }

    public static class FullPathSyncInfoElement
    extends SyncInfoModelElement {
        public FullPathSyncInfoElement(IDiffContainer parent, SyncInfo info) {
            super(parent, info);
        }

        public String getName() {
            IResource resource = this.getResource();
            return resource.getName() + " - " + resource.getFullPath().toString();
        }
    }

    public class ChangeLogActionGroup
    extends SynchronizePageActionGroup {
        private MenuManager sortByComment;
        private MenuManager sortByResource;

        public void initialize(ISynchronizePageConfiguration configuration) {
            super.initialize(configuration);
            this.sortByComment = new MenuManager(Policy.bind("ChangeLogModelProvider.0"));
            this.sortByResource = new MenuManager(Policy.bind("ChangeLogModelProvider.6"));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", ChangeLogModelProvider.SORT_ORDER_GROUP, (IContributionItem)this.sortByComment);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", ChangeLogModelProvider.SORT_ORDER_GROUP, (IContributionItem)this.sortByResource);
            ChangeLogModelSorter sorter = (ChangeLogModelSorter)ChangeLogModelProvider.this.getViewerSorter();
            this.sortByComment.add((IAction)new ToggleSortOrderAction(Policy.bind("ChangeLogModelProvider.1"), 2, 2, sorter.getCommentCriteria()));
            this.sortByComment.add((IAction)new ToggleSortOrderAction(Policy.bind("ChangeLogModelProvider.2"), 1, 2, sorter.getCommentCriteria()));
            this.sortByComment.add((IAction)new ToggleSortOrderAction(Policy.bind("ChangeLogModelProvider.3"), 3, 2, sorter.getCommentCriteria()));
            this.sortByResource.add((IAction)new ToggleSortOrderAction(Policy.bind("ChangeLogModelProvider.8"), 2, 1, sorter.getResourceCriteria()));
            this.sortByResource.add((IAction)new ToggleSortOrderAction(Policy.bind("ChangeLogModelProvider.7"), 1, 1, sorter.getResourceCriteria()));
            this.sortByResource.add((IAction)new ToggleSortOrderAction(Policy.bind("ChangeLogModelProvider.9"), 3, 1, sorter.getResourceCriteria()));
        }

        public void dispose() {
            this.sortByComment.dispose();
            this.sortByResource.dispose();
            this.sortByComment.removeAll();
            this.sortByResource.removeAll();
            super.dispose();
        }
    }

    private class ToggleSortOrderAction
    extends Action {
        private int criteria;
        private int sortType;
        public static final int RESOURCE_NAME = 1;
        public static final int COMMENT = 2;

        protected ToggleSortOrderAction(String name, int criteria, int sortType, int defaultCriteria) {
            super(name, 8);
            this.criteria = criteria;
            this.sortType = sortType;
            this.setChecked(criteria == defaultCriteria);
        }

        public void run() {
            StructuredViewer viewer = ChangeLogModelProvider.this.getViewer();
            if (viewer != null && !viewer.getControl().isDisposed()) {
                ChangeLogModelSorter sorter = (ChangeLogModelSorter)viewer.getSorter();
                if (this.isChecked() && sorter != null && this.getCriteria(sorter) != this.criteria) {
                    viewer.setSorter((ViewerSorter)this.createSorter(sorter));
                    String key = this.sortType == 1 ? ChangeLogModelProvider.P_LAST_RESOURCESORT : ChangeLogModelProvider.P_LAST_COMMENTSORT;
                    IDialogSettings pageSettings = ChangeLogModelProvider.this.getConfiguration().getSite().getPageSettings();
                    if (pageSettings != null) {
                        pageSettings.put(key, this.criteria);
                    }
                    this.update();
                }
            }
        }

        public void update() {
            ChangeLogModelSorter sorter;
            StructuredViewer viewer = ChangeLogModelProvider.this.getViewer();
            if (viewer != null && !viewer.getControl().isDisposed() && (sorter = (ChangeLogModelSorter)viewer.getSorter()) != null) {
                this.setChecked(this.getCriteria(sorter) == this.criteria);
            }
        }

        protected ChangeLogModelSorter createSorter(ChangeLogModelSorter sorter) {
            if (this.sortType == 2) {
                return new ChangeLogModelSorter(this.criteria, sorter.getResourceCriteria());
            }
            return new ChangeLogModelSorter(sorter.getCommentCriteria(), this.criteria);
        }

        protected int getCriteria(ChangeLogModelSorter sorter) {
            if (this.sortType == 2) {
                return sorter.getCommentCriteria();
            }
            return sorter.getResourceCriteria();
        }
    }
}

