/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javadocexport;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.jarpackager.CheckboxTreeAndListGroup;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocMemberContentProvider;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocOptionsManager;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocProjectContentProvider;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocWizardPage;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.help.WorkbenchHelp;

public class JavadocTreeWizardPage
extends JavadocWizardPage {
    private CheckboxTreeAndListGroup fInputGroup;
    private Text fDestinationText;
    private Combo fJavadocCommandText;
    private Text fDocletText;
    private Text fDocletTypeText;
    private Button fStandardButton;
    private Button fDestinationBrowserButton;
    private Button fCustomButton;
    private Button fPrivateVisibility;
    private Button fProtectedVisibility;
    private Button fPackageVisibility;
    private Button fPublicVisibility;
    private Label fDocletLabel;
    private Label fDocletTypeLabel;
    private Label fDestinationLabel;
    private CLabel fDescriptionLabel;
    private String fVisibilitySelection;
    private JavadocOptionsManager fStore;
    private StatusInfo fJavadocStatus;
    private StatusInfo fDestinationStatus;
    private StatusInfo fDocletStatus;
    private StatusInfo fTreeStatus;
    private StatusInfo fPreferenceStatus;
    private StatusInfo fWizardStatus;
    private final int PREFERENCESTATUS = 0;
    private final int CUSTOMSTATUS = 1;
    private final int STANDARDSTATUS = 2;
    private final int TREESTATUS = 3;
    private final int JAVADOCSTATUS = 4;

    protected JavadocTreeWizardPage(String pageName, JavadocOptionsManager store) {
        super(pageName);
        this.setDescription(JavadocExportMessages.getString("JavadocTreeWizardPage.javadoctreewizardpage.description"));
        this.fStore = store;
        this.fJavadocStatus = new StatusInfo();
        this.fDestinationStatus = new StatusInfo();
        this.fDocletStatus = new StatusInfo();
        this.fTreeStatus = new StatusInfo();
        this.fPreferenceStatus = new StatusInfo();
        this.fWizardStatus = store.getWizardStatus();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 6;
        composite.setLayout((Layout)layout);
        this.createJavadocCommandSet(composite);
        this.createInputGroup(composite);
        this.createVisibilitySet(composite);
        this.createOptionsSet(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.jdt.ui.javadoc_tree_page_context");
    }

    protected void createJavadocCommandSet(Composite composite) {
        int numColumns = 2;
        GridLayout layout = this.createGridLayout(2);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite group = new Composite(composite, 0);
        group.setLayoutData((Object)this.createGridData(768, 6, 0));
        group.setLayout((Layout)layout);
        this.createLabel(group, 0, JavadocExportMessages.getString("JavadocTreeWizardPage.javadoccommand.label"), this.createGridData(32, 2, 0));
        this.fJavadocCommandText = this.createCombo(group, 0, null, this.createGridData(768, 1, 0));
        this.fJavadocCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavadocTreeWizardPage.this.doValidation(4);
            }
        });
        Button javadocCommandBrowserButton = this.createButton(group, 8, JavadocExportMessages.getString("JavadocTreeWizardPage.javadoccommand.button.label"), this.createGridData(256, 1, 0));
        SWTUtil.setButtonDimensionHint(javadocCommandBrowserButton);
        javadocCommandBrowserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JavadocTreeWizardPage.this.browseForJavadocCommand();
            }
        });
    }

    protected void createInputGroup(Composite composite) {
        this.createLabel(composite, 0, JavadocExportMessages.getString("JavadocTreeWizardPage.checkboxtreeandlistgroup.label"), this.createGridData(6));
        Composite c = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        c.setLayout((Layout)layout);
        c.setLayoutData((Object)this.createGridData(768, 6, 0));
        JavadocProjectContentProvider treeContentProvider = new JavadocProjectContentProvider();
        JavadocMemberContentProvider listContentProvider = new JavadocMemberContentProvider();
        this.fInputGroup = new CheckboxTreeAndListGroup(c, (Object)this, treeContentProvider, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), (IStructuredContentProvider)listContentProvider, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), 0, this.convertWidthInCharsToPixels(60), this.convertHeightInCharsToPixels(10));
        this.fInputGroup.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                JavadocTreeWizardPage.this.doValidation(3);
            }
        });
        this.fInputGroup.setTreeSorter(new JavaElementSorter());
        IJavaElement[] elements = this.fStore.getInitialElements();
        this.setTreeChecked(elements);
        if (elements.length > 0) {
            this.fInputGroup.setTreeSelection((ISelection)new StructuredSelection((Object)elements[0].getJavaProject()));
        }
        this.fInputGroup.aboutToOpen();
    }

    private void createVisibilitySet(Composite composite) {
        GridLayout visibilityLayout = this.createGridLayout(4);
        visibilityLayout.marginHeight = 0;
        visibilityLayout.marginWidth = 0;
        Composite visibilityGroup = new Composite(composite, 0);
        visibilityGroup.setLayoutData((Object)this.createGridData(768, 6, 0));
        visibilityGroup.setLayout((Layout)visibilityLayout);
        this.createLabel(visibilityGroup, 0, JavadocExportMessages.getString("JavadocTreeWizardPage.visibilitygroup.label"), this.createGridData(768, 4, 0));
        this.fPrivateVisibility = this.createButton(visibilityGroup, 16, JavadocExportMessages.getString("JavadocTreeWizardPage.privatebutton.label"), this.createGridData(768, 1, 0));
        this.fPackageVisibility = this.createButton(visibilityGroup, 16, JavadocExportMessages.getString("JavadocTreeWizardPage.packagebutton.label"), this.createGridData(768, 1, 0));
        this.fProtectedVisibility = this.createButton(visibilityGroup, 16, JavadocExportMessages.getString("JavadocTreeWizardPage.protectedbutton.label"), this.createGridData(768, 1, 0));
        this.fPublicVisibility = this.createButton(visibilityGroup, 16, JavadocExportMessages.getString("JavadocTreeWizardPage.publicbutton.label"), this.createGridData(768, 1, 0));
        this.fDescriptionLabel = new CLabel(visibilityGroup, 16384);
        this.fDescriptionLabel.setLayoutData((Object)this.createGridData(768, 4, this.convertWidthInCharsToPixels(3) - 3));
        this.fPrivateVisibility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    JavadocTreeWizardPage.this.fVisibilitySelection = ((JavadocTreeWizardPage)JavadocTreeWizardPage.this).fStore.PRIVATE;
                    JavadocTreeWizardPage.this.fDescriptionLabel.setText(JavadocExportMessages.getString("JavadocTreeWizardPage.privatevisibilitydescription.label"));
                }
            }
        });
        this.fPackageVisibility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    JavadocTreeWizardPage.this.fVisibilitySelection = ((JavadocTreeWizardPage)JavadocTreeWizardPage.this).fStore.PACKAGE;
                    JavadocTreeWizardPage.this.fDescriptionLabel.setText(JavadocExportMessages.getString("JavadocTreeWizardPage.packagevisibledescription.label"));
                }
            }
        });
        this.fProtectedVisibility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    JavadocTreeWizardPage.this.fVisibilitySelection = ((JavadocTreeWizardPage)JavadocTreeWizardPage.this).fStore.PROTECTED;
                    JavadocTreeWizardPage.this.fDescriptionLabel.setText(JavadocExportMessages.getString("JavadocTreeWizardPage.protectedvisibilitydescription.label"));
                }
            }
        });
        this.fPublicVisibility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    JavadocTreeWizardPage.this.fVisibilitySelection = ((JavadocTreeWizardPage)JavadocTreeWizardPage.this).fStore.PUBLIC;
                    JavadocTreeWizardPage.this.fDescriptionLabel.setText(JavadocExportMessages.getString("JavadocTreeWizardPage.publicvisibilitydescription.label"));
                }
            }
        });
        this.setVisibilitySettings();
    }

    protected void setVisibilitySettings() {
        this.fVisibilitySelection = this.fStore.getAccess();
        this.fPrivateVisibility.setSelection(this.fVisibilitySelection.equals(this.fStore.PRIVATE));
        if (this.fPrivateVisibility.getSelection()) {
            this.fDescriptionLabel.setText(JavadocExportMessages.getString("JavadocTreeWizardPage.privatevisibilitydescription.label"));
        }
        this.fProtectedVisibility.setSelection(this.fVisibilitySelection.equals(this.fStore.PROTECTED));
        if (this.fProtectedVisibility.getSelection()) {
            this.fDescriptionLabel.setText(JavadocExportMessages.getString("JavadocTreeWizardPage.protectedvisibilitydescription.label"));
        }
        this.fPackageVisibility.setSelection(this.fVisibilitySelection.equals(this.fStore.PACKAGE));
        if (this.fPackageVisibility.getSelection()) {
            this.fDescriptionLabel.setText(JavadocExportMessages.getString("JavadocTreeWizardPage.packagevisibledescription.label"));
        }
        this.fPublicVisibility.setSelection(this.fVisibilitySelection.equals(this.fStore.PUBLIC));
        if (this.fPublicVisibility.getSelection()) {
            this.fDescriptionLabel.setText(JavadocExportMessages.getString("JavadocTreeWizardPage.publicvisibilitydescription.label"));
        }
    }

    private void createOptionsSet(Composite composite) {
        int numColumns = 4;
        GridLayout layout = this.createGridLayout(4);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite group = new Composite(composite, 0);
        group.setLayoutData((Object)this.createGridData(768, 6, 0));
        group.setLayout((Layout)layout);
        this.fStandardButton = this.createButton(group, 16, JavadocExportMessages.getString("JavadocTreeWizardPage.standarddocletbutton.label"), this.createGridData(256, 4, 0));
        this.fDestinationLabel = this.createLabel(group, 0, JavadocExportMessages.getString("JavadocTreeWizardPage.destinationfield.label"), this.createGridData(256, 1, this.convertWidthInCharsToPixels(3)));
        this.fDestinationText = this.createText(group, 2052, null, this.createGridData(768, 2, 0));
        ((GridData)this.fDestinationText.getLayoutData()).widthHint = 0;
        this.fDestinationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavadocTreeWizardPage.this.doValidation(2);
            }
        });
        this.fDestinationBrowserButton = this.createButton(group, 8, JavadocExportMessages.getString("JavadocTreeWizardPage.destinationbrowse.label"), this.createGridData(128, 1, 0));
        SWTUtil.setButtonDimensionHint(this.fDestinationBrowserButton);
        this.fCustomButton = this.createButton(group, 16, JavadocExportMessages.getString("JavadocTreeWizardPage.customdocletbutton.label"), this.createGridData(256, 4, 0));
        this.fDocletTypeLabel = this.createLabel(group, 0, JavadocExportMessages.getString("JavadocTreeWizardPage.docletnamefield.label"), this.createGridData(32, 1, this.convertWidthInCharsToPixels(3)));
        this.fDocletTypeText = this.createText(group, 2052, null, this.createGridData(256, 3, 0));
        ((GridData)this.fDocletTypeText.getLayoutData()).widthHint = 0;
        this.fDocletTypeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavadocTreeWizardPage.this.doValidation(1);
            }
        });
        this.fDocletLabel = this.createLabel(group, 0, JavadocExportMessages.getString("JavadocTreeWizardPage.docletpathfield.label"), this.createGridData(32, 1, this.convertWidthInCharsToPixels(3)));
        this.fDocletText = this.createText(group, 2052, null, this.createGridData(256, 3, 0));
        ((GridData)this.fDocletText.getLayoutData()).widthHint = 0;
        this.fDocletText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavadocTreeWizardPage.this.doValidation(1);
            }
        });
        this.fCustomButton.addSelectionListener((SelectionListener)new JavadocWizardPage.EnableSelectionAdapter(new Control[]{this.fDocletLabel, this.fDocletText, this.fDocletTypeLabel, this.fDocletTypeText}, new Control[]{this.fDestinationLabel, this.fDestinationText, this.fDestinationBrowserButton}));
        this.fCustomButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavadocTreeWizardPage.this.doValidation(1);
            }
        });
        this.fStandardButton.addSelectionListener((SelectionListener)new JavadocWizardPage.EnableSelectionAdapter(new Control[]{this.fDestinationLabel, this.fDestinationText, this.fDestinationBrowserButton}, new Control[]{this.fDocletLabel, this.fDocletText, this.fDocletTypeLabel, this.fDocletTypeText}));
        this.fStandardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavadocTreeWizardPage.this.doValidation(2);
            }
        });
        this.fDestinationBrowserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String text = JavadocTreeWizardPage.this.handleFolderBrowseButtonPressed(JavadocTreeWizardPage.this.fDestinationText.getText(), JavadocTreeWizardPage.this.fDestinationText.getShell(), JavadocExportMessages.getString("JavadocTreeWizardPage.destinationbrowsedialog.title"), JavadocExportMessages.getString("JavadocTreeWizardPage.destinationbrowsedialog.label"));
                JavadocTreeWizardPage.this.fDestinationText.setText(text);
            }
        });
        this.setOptionSetSettings();
    }

    public boolean getCustom() {
        return this.fCustomButton.getSelection();
    }

    private void setOptionSetSettings() {
        if (!this.fStore.isFromStandard()) {
            this.fCustomButton.setSelection(true);
            this.fDocletText.setText(this.fStore.getDocletPath());
            this.fDocletTypeText.setText(this.fStore.getDocletName());
            this.fDestinationText.setText(this.fStore.getDestination());
            this.fDestinationText.setEnabled(false);
            this.fDestinationBrowserButton.setEnabled(false);
            this.fDestinationLabel.setEnabled(false);
        } else {
            this.fStandardButton.setSelection(true);
            this.fDestinationText.setText(this.fStore.getDestination());
            this.fDocletText.setText(this.fStore.getDocletPath());
            this.fDocletTypeText.setText(this.fStore.getDocletName());
            this.fDocletText.setEnabled(false);
            this.fDocletLabel.setEnabled(false);
            this.fDocletTypeText.setEnabled(false);
            this.fDocletTypeLabel.setEnabled(false);
        }
        this.fJavadocCommandText.setItems(this.fStore.getJavadocCommandHistory());
        this.fJavadocCommandText.select(0);
    }

    private void setTreeChecked(IJavaElement[] sourceElements) {
        for (int i = 0; i < sourceElements.length; ++i) {
            IPackageFragmentRoot root;
            IJavaElement curr = sourceElements[i];
            if (curr instanceof ICompilationUnit) {
                this.fInputGroup.initialCheckListItem(curr);
                continue;
            }
            if (curr instanceof IPackageFragment) {
                this.fInputGroup.initialCheckTreeItem(curr);
                continue;
            }
            if (curr instanceof IJavaProject) {
                this.fInputGroup.initialCheckTreeItem(curr);
                continue;
            }
            if (!(curr instanceof IPackageFragmentRoot) || (root = (IPackageFragmentRoot)curr).isArchive()) continue;
            this.fInputGroup.initialCheckTreeItem(curr);
        }
    }

    private IPath[] getSourcePath(IJavaProject[] projects) {
        HashSet<IPath> res = new HashSet<IPath>();
        for (int k = 0; k < projects.length; ++k) {
            IJavaProject iJavaProject = projects[k];
            try {
                IPackageFragmentRoot[] roots = iJavaProject.getPackageFragmentRoots();
                for (int i = 0; i < roots.length; ++i) {
                    IPath p;
                    IResource resource;
                    IPackageFragmentRoot curr = roots[i];
                    if (curr.getKind() != 1 || (resource = curr.getResource()) == null || (p = resource.getLocation()) == null) continue;
                    res.add(p);
                }
                continue;
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return res.toArray(new IPath[res.size()]);
    }

    private IPath[] getClassPath(IJavaProject[] javaProjects) {
        HashSet<Path> res = new HashSet<Path>();
        for (int j = 0; j < javaProjects.length; ++j) {
            IJavaProject curr = javaProjects[j];
            try {
                IPath p = curr.getProject().getLocation();
                if (p == null) continue;
                IPath outputLocation = p.append(curr.getOutputLocation());
                String[] classPath = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)curr);
                for (int i = 0; i < classPath.length; ++i) {
                    Path path = new Path(classPath[i]);
                    if (outputLocation.equals(path)) continue;
                    res.add(path);
                }
                continue;
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
        return res.toArray(new IPath[res.size()]);
    }

    private IJavaElement[] getSourceElements(IJavaProject[] projects) {
        ArrayList<Object> res = new ArrayList<Object>();
        try {
            Set allChecked = this.fInputGroup.getAllCheckedTreeItems();
            HashSet<String> incompletePackages = new HashSet<String>();
            for (int h = 0; h < projects.length; ++h) {
                IJavaProject iJavaProject = projects[h];
                IPackageFragmentRoot[] roots = iJavaProject.getPackageFragmentRoots();
                for (int i = 0; i < roots.length; ++i) {
                    IPackageFragmentRoot root = roots[i];
                    if (root.getKind() != 1) continue;
                    IJavaElement[] packs = root.getChildren();
                    for (int k = 0; k < packs.length; ++k) {
                        IJavaElement curr = packs[k];
                        if (curr.getElementType() != 4 || curr.getElementName().length() != 0 && allChecked.contains(curr) && !this.fInputGroup.isTreeItemGreyChecked(curr)) continue;
                        incompletePackages.add(curr.getElementName());
                    }
                }
            }
            Iterator checkedElements = this.fInputGroup.getAllCheckedListItems();
            while (checkedElements.hasNext()) {
                ICompilationUnit unit;
                Object element = checkedElements.next();
                if (!(element instanceof ICompilationUnit) || !incompletePackages.contains((unit = (ICompilationUnit)element).getParent().getElementName())) continue;
                res.add(unit);
            }
            HashSet<String> addedPackages = new HashSet<String>();
            checkedElements = allChecked.iterator();
            while (checkedElements.hasNext()) {
                IPackageFragment fragment;
                String name;
                Object element = checkedElements.next();
                if (!(element instanceof IPackageFragment) || incompletePackages.contains(name = (fragment = (IPackageFragment)element).getElementName()) || addedPackages.contains(name)) continue;
                res.add(fragment);
                addedPackages.add(name);
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return res.toArray(new IJavaElement[res.size()]);
    }

    protected void updateStore(IJavaProject[] checkedProjects) {
        if (this.fCustomButton.getSelection()) {
            this.fStore.setDocletName(this.fDocletTypeText.getText());
            this.fStore.setDocletPath(this.fDocletText.getText());
            this.fStore.setFromStandard(false);
        }
        if (this.fStandardButton.getSelection()) {
            this.fStore.setFromStandard(true);
            this.fStore.setDestination(this.fDestinationText.getText());
        }
        this.fStore.setSourcepath(this.getSourcePath(checkedProjects));
        this.fStore.setClasspath(this.getClassPath(checkedProjects));
        this.fStore.setAccess(this.fVisibilitySelection);
        this.fStore.setSelectedElements(this.getSourceElements(checkedProjects));
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.fJavadocCommandText.getText());
        String[] items = this.fJavadocCommandText.getItems();
        for (int i = 0; i < items.length; ++i) {
            String curr = items[i];
            if (commands.contains(curr)) continue;
            commands.add(curr);
        }
        this.fStore.setJavadocCommandHistory(commands.toArray(new String[commands.size()]));
    }

    public IJavaProject[] getCheckedProjects() {
        ArrayList<Object> res = new ArrayList<Object>();
        TreeItem[] treeItems = this.fInputGroup.getTree().getItems();
        for (int i = 0; i < treeItems.length; ++i) {
            Object curr;
            if (!treeItems[i].getChecked() || !((curr = treeItems[i].getData()) instanceof IJavaProject)) continue;
            res.add(curr);
        }
        return res.toArray(new IJavaProject[res.size()]);
    }

    protected void doValidation(int validate) {
        switch (validate) {
            case 0: {
                this.fPreferenceStatus = new StatusInfo();
                this.fDocletStatus = new StatusInfo();
                this.updateStatus(this.findMostSevereStatus());
                break;
            }
            case 1: {
                if (!this.fCustomButton.getSelection()) break;
                this.fDestinationStatus = new StatusInfo();
                this.fDocletStatus = new StatusInfo();
                String doclet = this.fDocletTypeText.getText();
                String docletPath = this.fDocletText.getText();
                if (doclet.length() == 0) {
                    this.fDocletStatus.setError(JavadocExportMessages.getString("JavadocTreeWizardPage.nodocletname.error"));
                } else if (JavaConventions.validateJavaTypeName((String)doclet).matches(4)) {
                    this.fDocletStatus.setError(JavadocExportMessages.getString("JavadocTreeWizardPage.invaliddocletname.error"));
                } else if (docletPath.length() == 0 || !this.validDocletPath(docletPath)) {
                    this.fDocletStatus.setError(JavadocExportMessages.getString("JavadocTreeWizardPage.invaliddocletpath.error"));
                }
                this.updateStatus(this.findMostSevereStatus());
                break;
            }
            case 2: {
                if (!this.fStandardButton.getSelection()) break;
                this.fDestinationStatus = new StatusInfo();
                this.fDocletStatus = new StatusInfo();
                Path path = new Path(this.fDestinationText.getText());
                if (Path.ROOT.equals((Object)path) || Path.EMPTY.equals((Object)path)) {
                    this.fDestinationStatus.setError(JavadocExportMessages.getString("JavadocTreeWizardPage.nodestination.error"));
                }
                File file = new File(path.toOSString());
                if (!path.isValidPath(path.toOSString()) || file.isFile()) {
                    this.fDestinationStatus.setError(JavadocExportMessages.getString("JavadocTreeWizardPage.invaliddestination.error"));
                }
                if (path.append("package-list").toFile().exists() || path.append("index.html").toFile().exists()) {
                    this.fDestinationStatus.setWarning(JavadocExportMessages.getString("JavadocTreeWizardPage.warning.mayoverwritefiles"));
                }
                this.updateStatus(this.findMostSevereStatus());
                break;
            }
            case 3: {
                this.fTreeStatus = new StatusInfo();
                if (!this.fInputGroup.getAllCheckedListItems().hasNext()) {
                    this.fTreeStatus.setError(JavadocExportMessages.getString("JavadocTreeWizardPage.invalidtreeselection.error"));
                }
                this.updateStatus(this.findMostSevereStatus());
                break;
            }
            case 4: {
                this.fJavadocStatus = new StatusInfo();
                String text = this.fJavadocCommandText.getText();
                if (text.length() == 0) {
                    this.fJavadocStatus.setError(JavadocExportMessages.getString("JavadocTreeWizardPage.javadoccmd.error.enterpath"));
                } else {
                    File file = new File(text);
                    if (!file.isFile()) {
                        this.fJavadocStatus.setError(JavadocExportMessages.getString("JavadocTreeWizardPage.javadoccmd.error.notexists"));
                    }
                }
                this.updateStatus(this.findMostSevereStatus());
            }
        }
    }

    protected void browseForJavadocCommand() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(JavadocExportMessages.getString("JavadocTreeWizardPage.javadoccmd.dialog.title"));
        String dirName = this.fJavadocCommandText.getText();
        dialog.setFileName(dirName);
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            ArrayList<String> newItems = new ArrayList<String>();
            String[] items = this.fJavadocCommandText.getItems();
            newItems.add(selectedDirectory);
            for (int i = 0; i < items.length && newItems.size() < 5; ++i) {
                String curr = items[i];
                if (newItems.contains(curr)) continue;
                newItems.add(curr);
            }
            this.fJavadocCommandText.setItems(newItems.toArray(new String[newItems.size()]));
            this.fJavadocCommandText.select(0);
        }
    }

    private boolean validDocletPath(String docletPath) {
        StringTokenizer tokens = new StringTokenizer(docletPath, ";");
        while (tokens.hasMoreTokens()) {
            File file = new File(tokens.nextToken());
            if (file.exists()) continue;
            return false;
        }
        return true;
    }

    private IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere(new IStatus[]{this.fJavadocStatus, this.fPreferenceStatus, this.fDestinationStatus, this.fDocletStatus, this.fTreeStatus, this.fWizardStatus});
    }

    public void init() {
        this.updateStatus(new StatusInfo());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.doValidation(4);
            this.doValidation(2);
            this.doValidation(1);
            this.doValidation(3);
            this.doValidation(0);
        }
    }
}

