/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.plugin.JavaAttributeValue;

public class JavaAttributeWizardPage
extends NewClassWizardPage {
    private String className;
    private IProject project;
    private ISchemaAttribute attInfo;
    private IPluginModelBase model;
    private InitialClassProperties initialValues;
    private IJavaProject javaProject;
    private IStatus fClassNameStatus;
    private IStatus fPackageNameStatus;

    public JavaAttributeWizardPage(IProject project, IPluginModelBase model, ISchemaAttribute attInfo, String className) {
        this.className = className;
        this.model = model;
        this.project = project;
        this.attInfo = attInfo;
        try {
            this.javaProject = project.hasNature("org.eclipse.jdt.core.javanature") ? JavaCore.create((IProject)project) : null;
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        this.initialValues = new InitialClassProperties();
        this.initialValues.className = className;
    }

    public Object getValue() {
        return new JavaAttributeValue(this.project, this.model, this.attInfo, this.className);
    }

    public void init() {
        this.initializeExpectedValues();
        this.initializeWizardPage();
    }

    protected void initializeWizardPage() {
        this.setPackageFragmentRoot(this.initialValues.packageFragmentRoot, true);
        this.setPackageFragment(this.initialValues.packageFragment, true);
        this.setEnclosingType(null, true);
        this.setEnclosingTypeSelection(false, true);
        this.setTypeName(this.initialValues.className, true);
        this.setSuperClass(this.initialValues.superClassName, true);
        if (this.initialValues.interfaceName != null) {
            ArrayList<String> interfaces = new ArrayList<String>();
            interfaces.add(this.initialValues.interfaceName);
            this.setSuperInterfaces(interfaces, true);
        }
        boolean hasSuperClass = this.initialValues.superClassName != null && this.initialValues.superClassName.length() > 0;
        boolean hasInterface = this.initialValues.interfaceName != null && this.initialValues.interfaceName.length() > 0;
        this.setMethodStubSelection(false, hasSuperClass, hasInterface || hasSuperClass, true);
    }

    private IType findTypeForName(String typeName) throws JavaModelException {
        if (typeName == null || typeName.length() == 0) {
            return null;
        }
        IType type = null;
        String fileName = typeName.replace('.', '/') + ".java";
        IJavaElement element = this.javaProject.findElement((IPath)new Path(fileName));
        if (element == null) {
            return null;
        }
        if (element instanceof IClassFile) {
            type = ((IClassFile)element).getType();
        } else if (element instanceof ICompilationUnit) {
            IType[] types = ((ICompilationUnit)element).getTypes();
            type = types[0];
        }
        return type;
    }

    private void initializeExpectedValues() {
        int loc = this.className.indexOf(":");
        if (loc != -1) {
            if (loc < this.className.length()) {
                this.initialValues.classArgs = this.className.substring(loc + 1, this.className.length());
                this.className = this.className.substring(0, loc);
            }
            if (loc > 0) {
                this.initialValues.className = this.className.substring(0, loc);
            } else if (loc == 0) {
                this.initialValues.className = "";
            }
        }
        this.fClassNameStatus = JavaConventions.validateJavaTypeName((String)this.initialValues.className);
        loc = this.className.lastIndexOf(46);
        if (loc != -1) {
            this.initialValues.packageName = this.className.substring(0, loc);
            this.initialValues.className = this.className.substring(loc + 1);
            this.fPackageNameStatus = JavaConventions.validatePackageName((String)this.initialValues.packageName);
            this.fClassNameStatus = JavaConventions.validateJavaTypeName((String)this.initialValues.className);
        }
        if (this.javaProject == null) {
            return;
        }
        try {
            if (this.initialValues.packageFragmentRoot == null) {
                IPackageFragmentRoot srcEntryDft = null;
                IPackageFragmentRoot[] roots = this.javaProject.getPackageFragmentRoots();
                for (int i = 0; i < roots.length; ++i) {
                    if (roots[i].getKind() != 1) continue;
                    srcEntryDft = roots[i];
                    break;
                }
                this.initialValues.packageFragmentRoot = srcEntryDft != null ? srcEntryDft : this.javaProject.getPackageFragmentRoot(this.javaProject.getResource());
                if (this.initialValues.packageFragment == null && this.initialValues.packageFragmentRoot != null && this.initialValues.packageName != null && this.initialValues.packageName.length() > 0) {
                    IFolder packageFolder = this.project.getFolder(this.initialValues.packageName);
                    this.initialValues.packageFragment = this.initialValues.packageFragmentRoot.getPackageFragment(packageFolder.getProjectRelativePath().toOSString());
                }
            }
            if (this.attInfo == null) {
                this.initialValues.superClassName = "org.eclipse.core.runtime.Plugin";
                IPluginImport[] imports = this.model.getPluginBase().getImports();
                for (int i = 0; i < imports.length; ++i) {
                    if (!imports[i].getId().equals("org.eclipse.ui")) continue;
                    this.initialValues.superClassName = "org.eclipse.ui.plugin.AbstractUIPlugin";
                    break;
                }
                this.initialValues.superClassType = this.findTypeForName(this.initialValues.superClassName);
                return;
            }
            String schemaBasedOn = this.attInfo.getBasedOn();
            if (schemaBasedOn == null || schemaBasedOn.length() == 0) {
                this.initialValues.superClassName = "java.lang.Object";
                this.initialValues.superClassType = this.findTypeForName(this.initialValues.superClassName);
                return;
            }
            int del = schemaBasedOn.indexOf(58);
            if (del != -1) {
                this.initialValues.superClassName = schemaBasedOn.substring(0, del);
                this.initialValues.superClassType = this.findTypeForName(this.initialValues.superClassName);
                this.initialValues.interfaceName = schemaBasedOn.substring(del + 1);
                this.initialValues.interfaceType = this.findTypeForName(this.initialValues.interfaceName);
            } else {
                int schemaLoc = schemaBasedOn.lastIndexOf(".");
                if (schemaLoc != -1 && schemaLoc < schemaBasedOn.length()) {
                    IType type = this.findTypeForName(schemaBasedOn);
                    if (type != null && type.isInterface()) {
                        this.initialValues.interfaceName = schemaBasedOn;
                        this.initialValues.interfaceType = type;
                    } else if (type != null && type.isClass()) {
                        this.initialValues.superClassName = schemaBasedOn;
                        this.initialValues.superClassType = type;
                    }
                }
            }
        }
        catch (JavaModelException e) {
            PDEPlugin.logException(e);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.fClassNameStatus != null && !this.fClassNameStatus.isOK()) {
            this.updateStatus(this.fClassNameStatus);
        }
        if (this.fPackageNameStatus != null && !this.fPackageNameStatus.isOK()) {
            this.updateStatus(this.fPackageNameStatus);
        }
    }

    public String getClassArgs() {
        if (this.initialValues.classArgs == null) {
            return "";
        }
        return this.initialValues.classArgs;
    }

    class InitialClassProperties {
        IType superClassType = null;
        String superClassName = "";
        IType interfaceType = null;
        String interfaceName = null;
        String className = null;
        String classArgs = null;
        String packageName = null;
        IPackageFragmentRoot packageFragmentRoot = null;
        IPackageFragment packageFragment = null;
    }
}

