/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.index;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.jdt.internal.compiler.util.HashtableOfIntValues;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.core.index.EntryResult;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.index.MemoryIndex;
import org.eclipse.jdt.internal.core.util.SimpleLookupTable;
import org.eclipse.jdt.internal.core.util.SimpleSet;
import org.eclipse.jdt.internal.core.util.SimpleWordSet;
import org.eclipse.jdt.internal.core.util.Util;

public class DiskIndex {
    String fileName;
    private int headerInfoOffset;
    private int numberOfChunks;
    private int sizeOfLastChunk;
    private int[] chunkOffsets;
    private int documentReferenceSize;
    private HashtableOfIntValues categoryOffsets;
    private int cacheUserCount;
    private String[][] cachedChunks;
    private HashtableOfObject categoryTables;
    public static final String SIGNATURE = "INDEX VERSION 1.002";
    public static boolean DEBUG = false;
    private static final int RE_INDEXED = -1;
    private static final int DELETED = -2;
    private static final int CHUNK_SIZE = 100;

    DiskIndex(String fileName) {
        this.fileName = fileName;
        this.headerInfoOffset = -1;
        this.numberOfChunks = -1;
        this.sizeOfLastChunk = -1;
        this.chunkOffsets = null;
        this.documentReferenceSize = -1;
        this.cacheUserCount = -1;
        this.cachedChunks = null;
        this.categoryTables = null;
        this.categoryOffsets = null;
    }

    SimpleSet addDocumentNames(String substring, MemoryIndex memoryIndex) throws IOException {
        String[] docNames = this.readAllDocumentNames();
        SimpleSet results = new SimpleSet(docNames.length);
        if (substring == null) {
            if (memoryIndex == null) {
                int l = docNames.length;
                for (int i = 0; i < l; ++i) {
                    results.add(docNames[i]);
                }
            } else {
                SimpleLookupTable docsToRefs = memoryIndex.docsToReferences;
                int l = docNames.length;
                for (int i = 0; i < l; ++i) {
                    String docName = docNames[i];
                    if (docsToRefs.containsKey(docName)) continue;
                    results.add(docName);
                }
            }
        } else if (memoryIndex == null) {
            int l = docNames.length;
            for (int i = 0; i < l; ++i) {
                if (!docNames[i].startsWith(substring, 0)) continue;
                results.add(docNames[i]);
            }
        } else {
            SimpleLookupTable docsToRefs = memoryIndex.docsToReferences;
            int l = docNames.length;
            for (int i = 0; i < l; ++i) {
                String docName = docNames[i];
                if (!docName.startsWith(substring, 0) || docsToRefs.containsKey(docName)) continue;
                results.add(docName);
            }
        }
        return results;
    }

    private void addQueryResult(HashtableOfObject results, char[] word, HashtableOfObject wordsToDocNumbers, MemoryIndex memoryIndex) throws IOException {
        EntryResult result = (EntryResult)results.get(word);
        if (memoryIndex == null) {
            if (result == null) {
                results.put(word, new EntryResult(word, wordsToDocNumbers));
            } else {
                result.addDocumentTable(wordsToDocNumbers);
            }
        } else {
            SimpleLookupTable docsToRefs = memoryIndex.docsToReferences;
            if (result == null) {
                result = new EntryResult(word, null);
            }
            int[] docNumbers = this.readDocumentNumbers(wordsToDocNumbers.get(word));
            int l = docNumbers.length;
            for (int i = 0; i < l; ++i) {
                String docName = this.readDocumentName(docNumbers[i]);
                if (docsToRefs.containsKey(docName)) continue;
                result.addDocumentName(docName);
            }
            if (!result.isEmpty()) {
                results.put(word, result);
            }
        }
    }

    HashtableOfObject addQueryResults(char[][] categories, char[] key, int matchRule, MemoryIndex memoryIndex) throws IOException {
        HashtableOfObject results = new HashtableOfObject(13);
        if (this.categoryOffsets == null) {
            return results;
        }
        if (matchRule == 8) {
            int l = categories.length;
            for (int i = 0; i < l; ++i) {
                HashtableOfObject wordsToDocNumbers = this.readCategoryTable(categories[i], false);
                if (wordsToDocNumbers == null || !wordsToDocNumbers.containsKey(key)) continue;
                this.addQueryResult(results, key, wordsToDocNumbers, memoryIndex);
            }
        } else {
            int l = categories.length;
            for (int i = 0; i < l; ++i) {
                HashtableOfObject wordsToDocNumbers = this.readCategoryTable(categories[i], false);
                if (wordsToDocNumbers == null) continue;
                char[][] words = wordsToDocNumbers.keyTable;
                int m = words.length;
                for (int j = 0; j < m; ++j) {
                    char[] word = words[j];
                    if (word == null || !Index.isMatch(key, word, matchRule)) continue;
                    this.addQueryResult(results, word, wordsToDocNumbers, memoryIndex);
                }
            }
        }
        return results;
    }

    private String[] computeDocumentNames(String[] onDiskNames, int[] positions, SimpleLookupTable indexedDocuments, MemoryIndex memoryIndex) {
        int count;
        int onDiskLength = onDiskNames.length;
        Object[] docNames = memoryIndex.docsToReferences.keyTable;
        Object[] referenceTables = memoryIndex.docsToReferences.valueTable;
        if (onDiskLength == 0) {
            int i;
            int l = referenceTables.length;
            for (int i2 = 0; i2 < l; ++i2) {
                if (referenceTables[i2] == null) continue;
                indexedDocuments.put(docNames[i2], null);
            }
            String[] newDocNames = new String[indexedDocuments.elementSize];
            int count2 = 0;
            Object[] added = indexedDocuments.keyTable;
            int l2 = added.length;
            for (i = 0; i < l2; ++i) {
                if (added[i] == null) continue;
                newDocNames[count2++] = (String)added[i];
            }
            Util.sort(newDocNames);
            l2 = newDocNames.length;
            for (i = 0; i < l2; ++i) {
                indexedDocuments.put(newDocNames[i], new Integer(i));
            }
            return newDocNames;
        }
        for (int i = 0; i < onDiskLength; ++i) {
            positions[i] = i;
        }
        int numDeletedDocNames = 0;
        int numReindexedDocNames = 0;
        int l = docNames.length;
        block8: for (int i = 0; i < l; ++i) {
            String docName = (String)docNames[i];
            if (docName == null) continue;
            for (int j = 0; j < onDiskLength; ++j) {
                if (!docName.equals(onDiskNames[j])) continue;
                if (referenceTables[i] == null) {
                    positions[j] = -2;
                    ++numDeletedDocNames;
                    continue block8;
                }
                positions[j] = -1;
                ++numReindexedDocNames;
                continue block8;
            }
            if (referenceTables[i] == null) continue;
            indexedDocuments.put(docName, null);
        }
        String[] newDocNames = onDiskNames;
        if (numDeletedDocNames > 0 || indexedDocuments.elementSize > 0) {
            int i;
            newDocNames = new String[onDiskLength + indexedDocuments.elementSize - numDeletedDocNames];
            count = 0;
            for (int i3 = 0; i3 < onDiskLength; ++i3) {
                if (positions[i3] < -1) continue;
                newDocNames[count++] = onDiskNames[i3];
            }
            Object[] added = indexedDocuments.keyTable;
            int l3 = added.length;
            for (i = 0; i < l3; ++i) {
                if (added[i] == null) continue;
                newDocNames[count++] = (String)added[i];
            }
            Util.sort(newDocNames);
            l3 = newDocNames.length;
            for (i = 0; i < l3; ++i) {
                if (!indexedDocuments.containsKey(newDocNames[i])) continue;
                indexedDocuments.put(newDocNames[i], new Integer(i));
            }
        }
        count = -1;
        int i = 0;
        block13: while (i < onDiskLength) {
            switch (positions[i]) {
                case -2: {
                    ++i;
                    continue block13;
                }
                case -1: {
                    String newName;
                    if (!(newName = newDocNames[++count]).equals(onDiskNames[i])) continue block13;
                    indexedDocuments.put(newName, new Integer(count));
                    ++i;
                    continue block13;
                }
            }
            if (!newDocNames[++count].equals(onDiskNames[i])) continue;
            positions[i++] = count;
        }
        return newDocNames;
    }

    private void copyQueryResults(HashtableOfObject categoryToWords, int newPosition) throws IOException {
        char[][] categoryNames = categoryToWords.keyTable;
        Object[] wordSets = categoryToWords.valueTable;
        int l = categoryNames.length;
        for (int i = 0; i < l; ++i) {
            char[] categoryName = categoryNames[i];
            if (categoryName == null) continue;
            SimpleWordSet wordSet = (SimpleWordSet)wordSets[i];
            HashtableOfObject wordsToDocs = (HashtableOfObject)this.categoryTables.get(categoryName);
            if (wordsToDocs == null) {
                wordsToDocs = new HashtableOfObject(wordSet.elementSize);
                this.categoryTables.put(categoryName, wordsToDocs);
            }
            char[][] words = wordSet.words;
            int m = words.length;
            for (int j = 0; j < m; ++j) {
                char[] word = words[j];
                if (word == null) continue;
                Object o = wordsToDocs.get(word);
                if (o == null) {
                    wordsToDocs.put(word, new int[]{newPosition});
                    continue;
                }
                if (o instanceof IntList) {
                    ((IntList)o).add(newPosition);
                    continue;
                }
                IntList list = new IntList((int[])o);
                list.add(newPosition);
                wordsToDocs.put(word, list);
            }
        }
    }

    File getIndexFile() {
        if (this.fileName == null) {
            return null;
        }
        return new File(this.fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize(boolean reuseExistingFile) throws IOException {
        File indexFile = this.getIndexFile();
        if (indexFile.exists()) {
            if (reuseExistingFile) {
                RandomAccessFile file = new RandomAccessFile(this.fileName, "r");
                try {
                    String signature = file.readUTF();
                    if (!signature.equals(SIGNATURE)) {
                        throw new IOException(Util.bind("exception.wrongFormat"));
                    }
                    this.headerInfoOffset = file.readInt();
                    if (this.headerInfoOffset > 0) {
                        this.readHeaderInfo(file);
                    }
                }
                finally {
                    file.close();
                }
                return;
            }
            if (!indexFile.delete()) {
                if (DEBUG) {
                    System.out.println("initialize - Failed to delete index " + this.fileName);
                }
                throw new IOException("Failed to delete index " + this.fileName);
            }
        }
        if (indexFile.createNewFile()) {
            RandomAccessFile file = new RandomAccessFile(this.fileName, "rw");
            try {
                file.writeUTF(SIGNATURE);
                file.writeInt(-1);
            }
            finally {
                file.close();
            }
        } else {
            if (DEBUG) {
                System.out.println("initialize - Failed to create new index " + this.fileName);
            }
            throw new IOException("Failed to create new index " + this.fileName);
        }
    }

    private void initializeFrom(DiskIndex diskIndex, File newIndexFile) throws IOException {
        if (newIndexFile.exists() && !newIndexFile.delete()) {
            if (DEBUG) {
                System.out.println("initializeFrom - Failed to delete temp index " + this.fileName);
            }
        } else if (!newIndexFile.createNewFile()) {
            if (DEBUG) {
                System.out.println("initializeFrom - Failed to create temp index " + this.fileName);
            }
            throw new IOException("Failed to create temp index " + this.fileName);
        }
        int size = diskIndex.categoryOffsets == null ? 8 : diskIndex.categoryOffsets.elementSize;
        this.categoryOffsets = new HashtableOfIntValues(size);
        this.categoryTables = new HashtableOfObject(size);
    }

    private void mergeCategories(DiskIndex onDisk, int[] positions, DataOutputStream stream) throws IOException {
        char[][] oldNames = onDisk.categoryOffsets.keyTable;
        int l = oldNames.length;
        for (int i = 0; i < l; ++i) {
            char[] oldName = oldNames[i];
            if (oldName == null || this.categoryTables.containsKey(oldName)) continue;
            this.categoryTables.put(oldName, null);
        }
        char[][] categoryNames = this.categoryTables.keyTable;
        int l2 = categoryNames.length;
        for (int i = 0; i < l2; ++i) {
            if (categoryNames[i] == null) continue;
            this.mergeCategory(categoryNames[i], onDisk, positions, stream);
        }
        this.categoryTables = null;
    }

    private void mergeCategory(char[] categoryName, DiskIndex onDisk, int[] positions, DataOutputStream stream) throws IOException {
        HashtableOfObject oldWordsToDocs;
        HashtableOfObject wordsToDocs = (HashtableOfObject)this.categoryTables.get(categoryName);
        if (wordsToDocs == null) {
            wordsToDocs = new HashtableOfObject(3);
        }
        if ((oldWordsToDocs = onDisk.readCategoryTable(categoryName, true)) != null) {
            char[][] oldWords = oldWordsToDocs.keyTable;
            Object[] oldArrayOffsets = oldWordsToDocs.valueTable;
            int l = oldWords.length;
            for (int i = 0; i < l; ++i) {
                Object o;
                char[] oldWord = oldWords[i];
                if (oldWord == null) continue;
                int[] oldDocNumbers = (int[])oldArrayOffsets[i];
                int length = oldDocNumbers.length;
                int[] mappedNumbers = new int[length];
                int count = 0;
                for (int j = 0; j < length; ++j) {
                    int pos = positions[oldDocNumbers[j]];
                    if (pos <= -1) continue;
                    mappedNumbers[count++] = pos;
                }
                if (count < length) {
                    if (count == 0) continue;
                    int[] nArray = mappedNumbers;
                    mappedNumbers = new int[count];
                    System.arraycopy(nArray, 0, mappedNumbers, 0, count);
                }
                if ((o = wordsToDocs.get(oldWord)) == null) {
                    wordsToDocs.put(oldWord, mappedNumbers);
                    continue;
                }
                IntList list = null;
                if (o instanceof IntList) {
                    list = (IntList)o;
                } else {
                    list = new IntList((int[])o);
                    wordsToDocs.put(oldWord, list);
                }
                for (int j = 0; j < count; ++j) {
                    list.add(mappedNumbers[j]);
                }
            }
            onDisk.categoryTables.put(categoryName, null);
        }
        this.writeCategoryTable(categoryName, wordsToDocs, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DiskIndex mergeWith(MemoryIndex memoryIndex) throws IOException {
        String[] docNames = this.readAllDocumentNames();
        int previousLength = docNames.length;
        int[] positions = new int[previousLength];
        SimpleLookupTable indexedDocuments = new SimpleLookupTable(3);
        if ((docNames = this.computeDocumentNames(docNames, positions, indexedDocuments, memoryIndex)).length == 0) {
            if (previousLength == 0) {
                return this;
            }
            DiskIndex newDiskIndex = new DiskIndex(this.fileName);
            newDiskIndex.initialize(false);
            return newDiskIndex;
        }
        DiskIndex newDiskIndex = new DiskIndex(this.fileName + ".tmp");
        File newIndexFile = newDiskIndex.getIndexFile();
        try {
            newDiskIndex.initializeFrom(this, newIndexFile);
            DataOutputStream stream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(newIndexFile, false), 2048));
            int offsetToHeader = -1;
            try {
                newDiskIndex.writeAllDocumentNames(docNames, stream);
                docNames = null;
                if (indexedDocuments.elementSize > 0) {
                    Object[] names = indexedDocuments.keyTable;
                    Object[] integerPositions = indexedDocuments.valueTable;
                    int l = names.length;
                    for (int i = 0; i < l; ++i) {
                        if (names[i] == null) continue;
                        newDiskIndex.copyQueryResults((HashtableOfObject)memoryIndex.docsToReferences.get(names[i]), (Integer)integerPositions[i]);
                    }
                }
                indexedDocuments = null;
                if (previousLength == 0) {
                    newDiskIndex.writeCategories(stream);
                } else {
                    newDiskIndex.mergeCategories(this, positions, stream);
                }
                offsetToHeader = stream.size();
                newDiskIndex.writeHeaderInfo(stream);
                positions = null;
            }
            finally {
                stream.close();
            }
            newDiskIndex.writeOffsetToHeader(offsetToHeader);
            File old = this.getIndexFile();
            if (!old.delete()) {
                if (DEBUG) {
                    System.out.println("mergeWith - Failed to delete " + this.fileName);
                }
                throw new IOException("Failed to delete index file " + this.fileName);
            }
            if (!newIndexFile.renameTo(old)) {
                if (DEBUG) {
                    System.out.println("mergeWith - Failed to rename " + this.fileName);
                }
                throw new IOException("Failed to rename index file " + this.fileName);
            }
        }
        catch (IOException e) {
            if (newIndexFile.exists() && !newIndexFile.delete() && DEBUG) {
                System.out.println("mergeWith - Failed to delete temp index " + newDiskIndex.fileName);
            }
            throw e;
        }
        newDiskIndex.fileName = this.fileName;
        return newDiskIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String[] readAllDocumentNames() throws IOException {
        if (this.numberOfChunks <= 0) {
            return new String[0];
        }
        DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.getIndexFile()), 2048));
        try {
            stream.skip(this.chunkOffsets[0]);
            int lastIndex = this.numberOfChunks - 1;
            String[] docNames = new String[lastIndex * 100 + this.sizeOfLastChunk];
            for (int i = 0; i < this.numberOfChunks; ++i) {
                this.readChunk(docNames, stream, i * 100, i < lastIndex ? 100 : this.sizeOfLastChunk);
            }
            String[] stringArray = docNames;
            return stringArray;
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized HashtableOfObject readCategoryTable(char[] categoryName, boolean cacheDocNumbers) throws IOException {
        int offset = this.categoryOffsets.get(categoryName);
        if (offset == Integer.MIN_VALUE) {
            return null;
        }
        if (this.categoryTables == null) {
            this.categoryTables = new HashtableOfObject(this.categoryOffsets.elementSize);
        } else {
            HashtableOfObject cachedTable = (HashtableOfObject)this.categoryTables.get(categoryName);
            if (cachedTable != null) {
                return cachedTable;
            }
        }
        DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.getIndexFile()), 2048));
        HashtableOfObject categoryTable = null;
        Object matchingWords = null;
        int count = 0;
        int firstOffset = -1;
        try {
            stream.skip(offset);
            int size = stream.readInt();
            categoryTable = new HashtableOfObject(size);
            if (cacheDocNumbers) {
                matchingWords = new char[size][];
            }
            for (int i = 0; i < size; ++i) {
                char[] word = Util.readUTF(stream);
                int arrayOffset = stream.readInt();
                if (arrayOffset > 0) {
                    if (matchingWords != null) {
                        if (count == 0) {
                            firstOffset = arrayOffset;
                        }
                        matchingWords[count++] = word;
                    }
                    categoryTable.put(word, new Integer(arrayOffset));
                    continue;
                }
                categoryTable.put(word, new int[]{-arrayOffset});
            }
            this.categoryTables.put(categoryName, categoryTable);
        }
        finally {
            stream.close();
        }
        if (count > 0) {
            stream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.getIndexFile()), 2048));
            try {
                stream.skip(firstOffset);
                for (int i = 0; i < count; ++i) {
                    categoryTable.put(matchingWords[i], this.readDocumentArray(stream));
                }
            }
            finally {
                stream.close();
            }
        }
        return categoryTable;
    }

    private void readChunk(String[] docNames, DataInputStream stream, int index, int size) throws IOException {
        String current = stream.readUTF();
        docNames[index++] = current;
        for (int i = 1; i < size; ++i) {
            int length;
            int start = stream.readUnsignedByte();
            int end = stream.readUnsignedByte();
            String next = stream.readUTF();
            if (start > 0) {
                if (end > 0) {
                    length = current.length();
                    next = current.substring(0, start) + next + current.substring(length - end, length);
                } else {
                    next = current.substring(0, start) + next;
                }
            } else if (end > 0) {
                length = current.length();
                next = next + current.substring(length - end, length);
            }
            docNames[index++] = next;
            current = next;
        }
    }

    private int[] readDocumentArray(DataInputStream stream) throws IOException {
        int arraySize = stream.readShort();
        if (arraySize == Short.MAX_VALUE) {
            arraySize = stream.readInt();
        }
        int[] result = new int[arraySize];
        block4: for (int i = 0; i < arraySize; ++i) {
            switch (this.documentReferenceSize) {
                case 1: {
                    result[i] = stream.readUnsignedByte();
                    continue block4;
                }
                case 2: {
                    result[i] = stream.readUnsignedShort();
                    continue block4;
                }
                default: {
                    result[i] = stream.readInt();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized String readDocumentName(int docNumber) throws IOException {
        int chunkNumber;
        String[] chunk;
        if (this.cachedChunks == null) {
            this.cachedChunks = new String[this.numberOfChunks][];
        }
        if ((chunk = this.cachedChunks[chunkNumber = docNumber / 100]) == null) {
            DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.getIndexFile()), 2048));
            try {
                stream.skip(this.chunkOffsets[chunkNumber]);
                int size = chunkNumber == this.numberOfChunks - 1 ? this.sizeOfLastChunk : 100;
                chunk = new String[size];
                this.readChunk(chunk, stream, 0, size);
            }
            finally {
                stream.close();
            }
            this.cachedChunks[chunkNumber] = chunk;
        }
        return chunk[docNumber - chunkNumber * 100];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int[] readDocumentNumbers(Object arrayOffset) throws IOException {
        if (arrayOffset instanceof int[]) {
            return (int[])arrayOffset;
        }
        DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.getIndexFile()), 2048));
        try {
            stream.skip(((Integer)arrayOffset).intValue());
            int[] nArray = this.readDocumentArray(stream);
            return nArray;
        }
        finally {
            stream.close();
        }
    }

    private void readHeaderInfo(RandomAccessFile file) throws IOException {
        file.seek(this.headerInfoOffset);
        this.numberOfChunks = file.readInt();
        this.sizeOfLastChunk = file.readUnsignedByte();
        this.documentReferenceSize = file.readUnsignedByte();
        this.chunkOffsets = new int[this.numberOfChunks];
        for (int i = 0; i < this.numberOfChunks; ++i) {
            this.chunkOffsets[i] = file.readInt();
        }
        int size = file.readInt();
        this.categoryOffsets = new HashtableOfIntValues(size);
        for (int i = 0; i < size; ++i) {
            this.categoryOffsets.put(Util.readUTF(file), file.readInt());
        }
        this.categoryTables = new HashtableOfObject(size);
    }

    synchronized void startQuery() {
        ++this.cacheUserCount;
    }

    synchronized void stopQuery() {
        if (--this.cacheUserCount < 0) {
            this.cacheUserCount = -1;
            this.cachedChunks = null;
            this.categoryTables = null;
        }
    }

    private void writeAllDocumentNames(String[] sortedDocNames, DataOutputStream stream) throws IOException {
        if (sortedDocNames.length == 0) {
            throw new IllegalArgumentException();
        }
        stream.writeUTF(SIGNATURE);
        this.headerInfoOffset = stream.size();
        stream.writeInt(-1);
        int size = sortedDocNames.length;
        this.numberOfChunks = size / 100 + 1;
        this.sizeOfLastChunk = size % 100;
        if (this.sizeOfLastChunk == 0) {
            --this.numberOfChunks;
            this.sizeOfLastChunk = 100;
        }
        this.documentReferenceSize = size <= 127 ? 1 : (size <= Short.MAX_VALUE ? 2 : 4);
        this.chunkOffsets = new int[this.numberOfChunks];
        int lastIndex = this.numberOfChunks - 1;
        for (int i = 0; i < this.numberOfChunks; ++i) {
            this.chunkOffsets[i] = stream.size();
            int chunkSize = i == lastIndex ? this.sizeOfLastChunk : 100;
            int chunkIndex = i * 100;
            String current = sortedDocNames[chunkIndex];
            stream.writeUTF(current);
            for (int j = 1; j < chunkSize; ++j) {
                int len2;
                String next = sortedDocNames[chunkIndex + j];
                int len1 = current.length();
                int max = len1 < (len2 = next.length()) ? len1 : len2;
                int start = 0;
                while (current.charAt(start) == next.charAt(start) && max != ++start) {
                }
                if (start > 255) {
                    start = 255;
                }
                int end = 0;
                while (current.charAt(--len1) == next.charAt(--len2)) {
                    ++end;
                    if (len2 != start) continue;
                }
                if (end > 255) {
                    end = 255;
                }
                stream.writeByte(start);
                stream.writeByte(end);
                int last = next.length() - end;
                stream.writeUTF(start < last ? next.substring(start, last) : "");
                current = next;
            }
        }
    }

    private void writeCategories(DataOutputStream stream) throws IOException {
        char[][] categoryNames = this.categoryTables.keyTable;
        Object[] tables = this.categoryTables.valueTable;
        int l = categoryNames.length;
        for (int i = 0; i < l; ++i) {
            if (categoryNames[i] == null) continue;
            this.writeCategoryTable(categoryNames[i], (HashtableOfObject)tables[i], stream);
        }
        this.categoryTables = null;
    }

    private void writeCategoryTable(char[] categoryName, HashtableOfObject wordsToDocs, DataOutputStream stream) throws IOException {
        Object[] values = wordsToDocs.valueTable;
        int l = values.length;
        for (int i = 0; i < l; ++i) {
            Object o = values[i];
            if (o == null) continue;
            int[] documentNumbers = o instanceof int[] ? (int[])o : ((IntList)o).asArray();
            int length = documentNumbers.length;
            if (length == 1) {
                values[i] = new Integer(-documentNumbers[0]);
                continue;
            }
            values[i] = new Integer(stream.size());
            this.writeDocumentNumbers(documentNumbers, stream);
        }
        this.categoryOffsets.put(categoryName, stream.size());
        this.categoryTables.put(categoryName, null);
        stream.writeInt(wordsToDocs.elementSize);
        char[][] words = wordsToDocs.keyTable;
        int l2 = words.length;
        for (int i = 0; i < l2; ++i) {
            if (words[i] == null) continue;
            Util.writeUTF(stream, words[i]);
            stream.writeInt((Integer)values[i]);
        }
    }

    private void writeDocumentNumbers(int[] documentNumbers, DataOutputStream stream) throws IOException {
        int length = documentNumbers.length;
        if (length < Short.MAX_VALUE) {
            if (length == 0) {
                throw new IllegalArgumentException();
            }
            stream.writeShort(length);
        } else {
            stream.writeShort(Short.MAX_VALUE);
            stream.writeInt(length);
        }
        Util.sort(documentNumbers);
        block4: for (int i = 0; i < length; ++i) {
            switch (this.documentReferenceSize) {
                case 1: {
                    stream.writeByte(documentNumbers[i]);
                    continue block4;
                }
                case 2: {
                    stream.writeShort(documentNumbers[i]);
                    continue block4;
                }
                default: {
                    stream.writeInt(documentNumbers[i]);
                }
            }
        }
    }

    private void writeHeaderInfo(DataOutputStream stream) throws IOException {
        stream.writeInt(this.numberOfChunks);
        stream.writeByte(this.sizeOfLastChunk);
        stream.writeByte(this.documentReferenceSize);
        for (int i = 0; i < this.numberOfChunks; ++i) {
            stream.writeInt(this.chunkOffsets[i]);
        }
        stream.writeInt(this.categoryOffsets.elementSize);
        char[][] categoryNames = this.categoryOffsets.keyTable;
        int[] offsets = this.categoryOffsets.valueTable;
        int l = categoryNames.length;
        for (int i = 0; i < l; ++i) {
            if (categoryNames[i] == null) continue;
            Util.writeUTF(stream, categoryNames[i]);
            stream.writeInt(offsets[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOffsetToHeader(int offsetToHeader) throws IOException {
        if (offsetToHeader > 0) {
            RandomAccessFile file = new RandomAccessFile(this.fileName, "rw");
            try {
                file.seek(this.headerInfoOffset);
                file.writeInt(offsetToHeader);
                this.headerInfoOffset = offsetToHeader;
            }
            finally {
                file.close();
            }
        }
    }

    class IntList {
        int size;
        int[] elements;

        IntList(int[] elements) {
            this.elements = elements;
            this.size = elements.length;
        }

        void add(int newElement) {
            if (this.size == this.elements.length) {
                int newSize = this.size * 3;
                if (newSize < 7) {
                    newSize = 7;
                }
                this.elements = new int[newSize];
                System.arraycopy(this.elements, 0, this.elements, 0, this.size);
            }
            this.elements[this.size++] = newElement;
        }

        int[] asArray() {
            int[] result = new int[this.size];
            System.arraycopy(this.elements, 0, result, 0, this.size);
            return result;
        }
    }
}

