/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.views.navigator.FiltersContentProvider;
import org.eclipse.ui.views.navigator.StringMatcher;

public class ResourcePatternFilter
extends ViewerFilter {
    private String[] patterns;
    private StringMatcher[] matchers;
    static final String COMMA_SEPARATOR = ",";
    static final String FILTERS_TAG = "resourceFilters";
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    private StringMatcher[] getMatchers() {
        if (this.matchers == null) {
            this.initializeFromPreferences();
        }
        return this.matchers;
    }

    public String[] getPatterns() {
        if (this.patterns == null) {
            this.initializeFromPreferences();
        }
        return this.patterns;
    }

    private void initializeFromPreferences() {
        IPreferenceStore workbenchPrefs;
        IPreferenceStore viewsPrefs = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String storedPatterns = viewsPrefs.getString(FILTERS_TAG);
        if (storedPatterns.length() == 0 && (storedPatterns = (workbenchPrefs = PlatformUI.getWorkbench().getPreferenceStore()).getString(FILTERS_TAG)).length() > 0) {
            viewsPrefs.setValue(FILTERS_TAG, storedPatterns);
            workbenchPrefs.setValue(FILTERS_TAG, "");
        }
        if (storedPatterns.length() == 0) {
            List defaultFilters = FiltersContentProvider.getDefaultFilters();
            String[] patterns = new String[defaultFilters.size()];
            defaultFilters.toArray(patterns);
            this.setPatterns(patterns);
            return;
        }
        List definedFilters = FiltersContentProvider.getDefinedFilters();
        StringTokenizer entries = new StringTokenizer(storedPatterns, COMMA_SEPARATOR);
        ArrayList<String> patterns = new ArrayList<String>();
        while (entries.hasMoreElements()) {
            String nextToken = entries.nextToken();
            if (definedFilters.indexOf(nextToken) <= -1) continue;
            patterns.add(nextToken);
        }
        String[] patternArray = new String[patterns.size()];
        patterns.toArray(patternArray);
        this.setPatterns(patternArray);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IResource resource = null;
        if (element instanceof IResource) {
            resource = (IResource)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            resource = (IResource)adaptable.getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = ResourcePatternFilter.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource);
        }
        if (resource != null) {
            String name = resource.getName();
            StringMatcher[] testMatchers = this.getMatchers();
            for (int i = 0; i < testMatchers.length; ++i) {
                if (!testMatchers[i].match(name)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public void setPatterns(String[] newPatterns) {
        this.patterns = newPatterns;
        this.matchers = new StringMatcher[newPatterns.length];
        for (int i = 0; i < newPatterns.length; ++i) {
            this.matchers[i] = new StringMatcher(newPatterns[i], true, false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

