/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.launch;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.InstructionPointerManager;
import org.eclipse.debug.internal.ui.actions.AddToFavoritesAction;
import org.eclipse.debug.internal.ui.actions.EditLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.sourcelookup.CommonSourceNotFoundEditorInput;
import org.eclipse.debug.internal.ui.sourcelookup.EditSourceLookupPathAction;
import org.eclipse.debug.internal.ui.sourcelookup.LookupSourceAction;
import org.eclipse.debug.internal.ui.views.AbstractDebugEventHandlerView;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.DebugViewDecoratingLabelProvider;
import org.eclipse.debug.internal.ui.views.DebugViewInterimLabelProvider;
import org.eclipse.debug.internal.ui.views.DebugViewLabelDecorator;
import org.eclipse.debug.internal.ui.views.launch.DecorationManager;
import org.eclipse.debug.internal.ui.views.launch.LaunchViewContentProvider;
import org.eclipse.debug.internal.ui.views.launch.LaunchViewContextListener;
import org.eclipse.debug.internal.ui.views.launch.LaunchViewEventHandler;
import org.eclipse.debug.internal.ui.views.launch.LaunchViewer;
import org.eclipse.debug.internal.ui.views.launch.SourceNotFoundEditorInput;
import org.eclipse.debug.internal.ui.views.launch.StandardDecoration;
import org.eclipse.debug.ui.IDebugEditorPresentation;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener2;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class LaunchView
extends AbstractDebugEventHandlerView
implements ISelectionChangedListener,
IPerspectiveListener2,
IPageListener,
IPropertyChangeListener,
IResourceChangeListener,
IShowInTarget,
IShowInSource,
IShowInTargetList,
IPartListener2 {
    public static final String ID_CONTEXT_ACTIVITY_BINDINGS = "contextActivityBindings";
    private boolean fShowingEditor = false;
    private IStackFrame fStackFrame = null;
    private IEditorInput fEditorInput = null;
    private String fEditorId = null;
    private boolean fIsActive = true;
    private IEditorPart fEditor = null;
    private Object fSourceElement = null;
    private int fEditorIndex = -1;
    private boolean fReuseEditor = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IDebugUIConstants.PREF_REUSE_EDITOR);
    private IResourceDeltaVisitor fVisitor = null;
    private IDebugEditorPresentation fEditorPresentation = null;
    private EditLaunchConfigurationAction fEditConfigAction = null;
    private AddToFavoritesAction fAddToFavoritesAction = null;
    private EditSourceLookupPathAction fEditSourceAction = null;
    private LookupSourceAction fLookupAction = null;
    private LaunchViewContextListener fContextListener;
    static /* synthetic */ Class class$org$eclipse$ui$texteditor$ITextEditor;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public LaunchView() {
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected String getHelpContextId() {
        return IDebugHelpContextIds.DEBUG_VIEW;
    }

    protected void createActions() {
        this.setAction("Properties", (IAction)new PropertyDialogAction(this.getSite().getWorkbenchWindow().getShell(), this.getSite().getSelectionProvider()));
        this.fEditConfigAction = new EditLaunchConfigurationAction();
        this.fAddToFavoritesAction = new AddToFavoritesAction();
        this.fEditSourceAction = new EditSourceLookupPathAction(this);
        this.fLookupAction = new LookupSourceAction(this);
        Runnable r = new Runnable(){

            public void run() {
                LaunchView.this.initializeSelection();
            }
        };
        this.asyncExec(r);
    }

    protected Viewer createViewer(Composite parent) {
        LaunchViewer lv = new LaunchViewer(parent);
        lv.addPostSelectionChangedListener(this);
        lv.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    LaunchView.this.handleDeleteKeyPressed();
                }
            }
        });
        lv.setContentProvider((IContentProvider)this.createContentProvider());
        DelegatingModelPresentation presentation = new DelegatingModelPresentation();
        DebugViewDecoratingLabelProvider labelProvider = new DebugViewDecoratingLabelProvider((StructuredViewer)lv, new DebugViewInterimLabelProvider(presentation), new DebugViewLabelDecorator(presentation));
        lv.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fEditorPresentation = presentation;
        this.getSite().setSelectionProvider((ISelectionProvider)lv);
        lv.setInput(DebugPlugin.getDefault().getLaunchManager());
        this.setEventHandler(new LaunchViewEventHandler(this));
        this.setActive(this.getSite().getPage().findView(this.getSite().getId()) != null);
        return lv;
    }

    public DebugViewLabelDecorator getLabelDecorator() {
        return (DebugViewLabelDecorator)((DebugViewDecoratingLabelProvider)((LaunchViewer)this.getViewer()).getLabelProvider()).getLabelDecorator();
    }

    private void handleDeleteKeyPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        Iterator iter = selection.iterator();
        boolean itemsToTerminate = false;
        while (iter.hasNext()) {
            ITerminate terminable;
            Object item = iter.next();
            if (!(item instanceof ITerminate) || !(terminable = (ITerminate)item).canTerminate() || terminable.isTerminated()) continue;
            itemsToTerminate = true;
            break;
        }
        if (itemsToTerminate && !MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)DebugUIViewsMessages.getString("LaunchView.Terminate_and_Remove_1"), (String)DebugUIViewsMessages.getString("LaunchView.Terminate_and_remove_selected__2"))) {
            return;
        }
        MultiStatus status = new MultiStatus(DebugUIPlugin.getUniqueIdentifier(), 5012, DebugUIViewsMessages.getString("LaunchView.Exceptions_occurred_attempting_to_terminate_and_remove_3"), null);
        iter = selection.iterator();
        while (iter.hasNext()) {
            try {
                LaunchView.terminateAndRemove(iter.next());
            }
            catch (DebugException exception) {
                status.merge(exception.getStatus());
            }
        }
        if (!status.isOK()) {
            IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null) {
                DebugUIPlugin.errorDialog(window.getShell(), DebugUIViewsMessages.getString("LaunchView.Terminate_and_Remove_4"), DebugUIViewsMessages.getString("LaunchView.Terminate_and_remove_failed_5"), (IStatus)status);
            } else {
                DebugUIPlugin.log((IStatus)status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void terminateAndRemove(Object element) throws DebugException {
        if (!(element instanceof ITerminate)) {
            return;
        }
        ITerminate terminable = (ITerminate)element;
        if (!terminable.canTerminate() && !terminable.isTerminated()) {
            return;
        }
        try {
            if (!terminable.isTerminated()) {
                terminable.terminate();
            }
        }
        finally {
            LaunchView.remove(element);
        }
    }

    private static void remove(Object element) {
        ILaunch launch = null;
        if (element instanceof ILaunch) {
            launch = (ILaunch)element;
        } else if (element instanceof IDebugElement) {
            launch = ((IDebugElement)element).getLaunch();
        } else if (element instanceof IProcess) {
            launch = ((IProcess)element).getLaunch();
        } else {
            return;
        }
        ILaunchManager lManager = DebugPlugin.getDefault().getLaunchManager();
        lManager.removeLaunch(launch);
    }

    protected void initializeSelection() {
        if (!this.isAvailable()) {
            return;
        }
        TreeViewer tv = (TreeViewer)this.getViewer();
        tv.expandToLevel(2);
        Object[] elements = tv.getExpandedElements();
        for (int i = 0; i < elements.length; ++i) {
            IStackFrame frame;
            if (!(elements[i] instanceof ILaunch) || (frame = this.findFrame((ILaunch)elements[i])) == null) continue;
            this.autoExpand(frame, false, true);
        }
    }

    protected IStackFrame findFrame(ILaunch launch) {
        IDebugTarget target = launch.getDebugTarget();
        if (target != null) {
            try {
                IThread[] threads = target.getThreads();
                for (int i = 0; i < threads.length; ++i) {
                    if (!threads[i].isSuspended()) continue;
                    return threads[i].getTopStackFrame();
                }
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
        return null;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        site.getPage().addPartListener((IPartListener2)this);
        site.getWorkbenchWindow().addPageListener((IPageListener)this);
        site.getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        String index;
        super.init(site, memento);
        site.getPage().addPartListener((IPartListener2)this);
        site.getWorkbenchWindow().addPageListener((IPageListener)this);
        site.getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
        if (memento == null) {
            return;
        }
        if (this.fReuseEditor && (index = memento.getString(IDebugUIConstants.PREF_REUSE_EDITOR)) != null) {
            try {
                this.fEditorIndex = Integer.parseInt(index);
            }
            catch (NumberFormatException e) {
                DebugUIPlugin.log(e);
            }
        }
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator("threadGroup"));
        tbm.add((IContributionItem)new Separator("stepGroup"));
        tbm.add((IContributionItem)new GroupMarker("stepIntoGroup"));
        tbm.add((IContributionItem)new GroupMarker("stepOverGroup"));
        tbm.add((IContributionItem)new GroupMarker("stepReturnGroup"));
        tbm.add((IContributionItem)new GroupMarker("emptyStepGroup"));
        tbm.add((IContributionItem)new Separator("renderGroup"));
    }

    public void dispose() {
        if (this.getViewer() != null) {
            this.getViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (this.fContextListener != null) {
            this.fContextListener.dispose();
        }
        IWorkbenchPage page = this.getSite().getPage();
        page.removePartListener((IPartListener2)this);
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        window.removePerspectiveListener((IPerspectiveListener)this);
        window.removePageListener((IPageListener)this);
        this.cleanup();
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    protected void cleanup() {
        this.setEditorId(null);
        this.setEditorInput(null);
        this.setStackFrame(null);
    }

    protected IStructuredContentProvider createContentProvider() {
        return new LaunchViewContentProvider();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.clearStatusLine();
        this.updateObjects();
        this.showEditorForCurrentSelection();
        this.fContextListener.updateForSelection(((IStructuredSelection)this.getViewer().getSelection()).getFirstElement());
    }

    public void redoSourceLookup() {
        this.setStackFrame(null);
        this.selectionChanged(null);
    }

    protected void launchesTerminated(ILaunch[] launches) {
        this.fContextListener.launchesTerminated(launches);
        IStackFrame frame = this.getStackFrame();
        if (frame != null) {
            ILaunch launch = frame.getLaunch();
            for (int i = 0; i < launches.length; ++i) {
                ILaunch terminatedLaunch = launches[i];
                if (!terminatedLaunch.equals(launch)) continue;
                this.setStackFrame(null);
            }
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        TreeViewer tViewer;
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        Object o = ss.getFirstElement();
        if (o == null || o instanceof IStackFrame) {
            return;
        }
        boolean expanded = (tViewer = (TreeViewer)this.getViewer()).getExpandedState(o);
        tViewer.setExpandedState(o, !expanded);
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.setActive(page.findView(this.getSite().getId()) != null);
        this.updateObjects();
        this.showEditorForCurrentSelection();
        if (this.isActive()) {
            this.fContextListener.updateForSelection(((IStructuredSelection)this.getViewer().getSelection()).getFirstElement());
        }
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        this.setActive(page.findView(this.getSite().getId()) != null);
        if (this.fContextListener != null) {
            this.fContextListener.perspectiveChanged(page, changeId);
        }
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
        if (this.fContextListener != null) {
            this.fContextListener.perspectiveChanged(page, partRef, changeId);
        }
    }

    public void pageActivated(IWorkbenchPage page) {
        if (this.getSite().getPage().equals(page)) {
            this.setActive(true);
            this.updateObjects();
            this.showEditorForCurrentSelection();
            if (this.fContextListener != null) {
                this.fContextListener.loadTrackViews();
            }
        }
    }

    public void pageClosed(IWorkbenchPage page) {
    }

    public void pageOpened(IWorkbenchPage page) {
    }

    protected void showEditorForCurrentSelection() {
        if (!this.isActive()) {
            return;
        }
        ISelection selection = this.getViewer().getSelection();
        Object obj = null;
        if (selection instanceof IStructuredSelection) {
            obj = ((IStructuredSelection)selection).getFirstElement();
        }
        if (!(obj instanceof IStackFrame)) {
            return;
        }
        this.openEditorForStackFrame((IStackFrame)obj);
    }

    private void lookupEditorInput(IStackFrame stackFrame) {
        this.setEditorId(null);
        this.setEditorInput(null);
        this.setSourceElement(null);
        Object sourceElement = null;
        ILaunch launch = stackFrame.getLaunch();
        if (launch == null) {
            return;
        }
        ISourceLocator locator = launch.getSourceLocator();
        if (locator == null) {
            return;
        }
        sourceElement = locator.getSourceElement(stackFrame);
        if (sourceElement == null) {
            if (locator instanceof AbstractSourceLookupDirector) {
                this.commonSourceNotFound(stackFrame);
            } else {
                this.sourceNotFound(stackFrame);
            }
            return;
        }
        ISourcePresentation presentation = null;
        presentation = locator instanceof ISourcePresentation ? (ISourcePresentation)locator : this.getPresentation(stackFrame.getModelIdentifier());
        IEditorInput editorInput = null;
        String editorId = null;
        if (presentation != null) {
            editorInput = presentation.getEditorInput(sourceElement);
        }
        if (editorInput != null) {
            editorId = presentation.getEditorId(editorInput, sourceElement);
        }
        this.setEditorInput(editorInput);
        this.setEditorId(editorId);
        this.setSourceElement(sourceElement);
    }

    public IDebugModelPresentation getPresentation(String id) {
        return ((DelegatingModelPresentation)this.fEditorPresentation).getPresentation(id);
    }

    private void sourceNotFound(IStackFrame frame) {
        this.setEditorInput(new SourceNotFoundEditorInput(frame));
        this.setEditorId("org.eclipse.debug.ui.NoSourceFoundEditor");
    }

    private void commonSourceNotFound(IStackFrame frame) {
        this.setEditorInput(new CommonSourceNotFoundEditorInput(frame));
        this.setEditorId("org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openEditorForStackFrame(IStackFrame stackFrame) {
        if (this.fShowingEditor) {
            return;
        }
        try {
            this.fShowingEditor = true;
            if (!stackFrame.isSuspended()) {
                return;
            }
            if (stackFrame.equals(this.getStackFrame())) {
                if (this.getEditorInput() == null || this.getEditorId() == null) {
                    this.lookupEditorInput(stackFrame);
                }
            } else {
                this.setStackFrame(stackFrame);
                this.lookupEditorInput(stackFrame);
            }
            if (this.getEditorInput() == null || this.getEditorId() == null) {
                return;
            }
            IEditorPart editor = this.openEditor();
            if (editor == null) {
                return;
            }
            if (this.fEditorPresentation.addAnnotations(editor, stackFrame)) {
                StandardDecoration decoration = new StandardDecoration(this.fEditorPresentation, editor, stackFrame.getThread());
                DecorationManager.addDecoration(decoration);
            } else {
                ITextEditor textEditor = null;
                textEditor = editor instanceof ITextEditor ? (ITextEditor)editor : (ITextEditor)editor.getAdapter(class$org$eclipse$ui$texteditor$ITextEditor == null ? (class$org$eclipse$ui$texteditor$ITextEditor = LaunchView.class$("org.eclipse.ui.texteditor.ITextEditor")) : class$org$eclipse$ui$texteditor$ITextEditor);
                if (textEditor != null) {
                    this.positionEditor(textEditor, stackFrame);
                    InstructionPointerManager.getDefault().addAnnotation(textEditor, stackFrame);
                }
            }
        }
        finally {
            this.fShowingEditor = false;
        }
    }

    private void positionEditor(ITextEditor editor, IStackFrame frame) {
        try {
            IRegion region;
            int charStart = frame.getCharStart();
            if (charStart > 0) {
                editor.selectAndReveal(charStart, 0);
                return;
            }
            int lineNumber = frame.getLineNumber();
            if ((region = this.getLineInformation(editor, --lineNumber)) != null) {
                editor.selectAndReveal(region.getOffset(), 0);
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRegion getLineInformation(ITextEditor editor, int lineNumber) {
        IDocumentProvider provider = editor.getDocumentProvider();
        IEditorInput input = editor.getEditorInput();
        try {
            provider.connect((Object)input);
        }
        catch (CoreException e) {
            return null;
        }
        try {
            IDocument document = provider.getDocument((Object)input);
            if (document != null) {
                IRegion iRegion = document.getLineInformation(lineNumber);
                return iRegion;
            }
        }
        catch (BadLocationException e) {
        }
        finally {
            provider.disconnect((Object)input);
        }
        return null;
    }

    private IEditorPart openEditor() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        if (this.fEditorIndex >= 0) {
            IEditorReference[] refs = page.getEditorReferences();
            if (this.fEditorIndex < refs.length) {
                this.fEditor = refs[this.fEditorIndex].getEditor(false);
            }
            this.fEditorIndex = -1;
        }
        IEditorPart editor = null;
        IEditorInput input = this.getEditorInput();
        String id = this.getEditorId();
        if (input == null || id == null) {
            return null;
        }
        if (this.fReuseEditor) {
            editor = page.getActiveEditor();
            if (editor != null && !editor.getEditorInput().equals(input)) {
                editor = null;
            }
            if (editor == null) {
                IEditorReference[] refs = page.getEditorReferences();
                for (int i = 0; i < refs.length; ++i) {
                    IEditorPart refEditor = refs[i].getEditor(false);
                    if (refEditor == null || !input.equals(refEditor.getEditorInput())) continue;
                    editor = refEditor;
                    page.bringToTop((IWorkbenchPart)editor);
                    break;
                }
            }
            if (editor == null) {
                if (this.fEditor == null || this.fEditor.isDirty() || page.isEditorPinned(this.fEditor)) {
                    this.fEditor = editor = this.openEditor(page, input, id);
                } else if (this.fEditor instanceof IReusableEditor && this.fEditor.getSite().getId().equals(id)) {
                    ((IReusableEditor)this.fEditor).setInput(input);
                    editor = this.fEditor;
                    page.bringToTop((IWorkbenchPart)editor);
                } else {
                    editor = this.openEditor(page, input, id);
                    page.closeEditor(this.fEditor, false);
                    this.fEditor = editor;
                }
            }
        } else {
            editor = this.openEditor(page, input, id);
        }
        return editor;
    }

    private IEditorPart openEditor(final IWorkbenchPage page, final IEditorInput input, final String id) {
        final IEditorPart[] editor = new IEditorPart[]{null};
        Runnable r = new Runnable(){

            public void run() {
                try {
                    editor[0] = page.openEditor(input, id, false);
                }
                catch (PartInitException e) {
                    DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), DebugUIViewsMessages.getString("LaunchView.Error_1"), DebugUIViewsMessages.getString("LaunchView.Exception_occurred_opening_editor_for_debugger._2"), e);
                }
            }
        };
        BusyIndicator.showWhile((Display)DebugUIPlugin.getStandardDisplay(), (Runnable)r);
        return editor[0];
    }

    public void clearSourceSelection(Object source) {
        if (source instanceof IThread) {
            IThread thread = (IThread)source;
            DecorationManager.removeDecorations(thread);
            InstructionPointerManager.getDefault().removeAnnotations(thread);
        } else if (source instanceof IDebugTarget) {
            IDebugTarget target = (IDebugTarget)source;
            DecorationManager.removeDecorations(target);
            InstructionPointerManager.getDefault().removeAnnotations(target);
        }
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("emptyEditGroup"));
        menu.add((IContributionItem)new Separator("editGroup"));
        menu.add((IContributionItem)new Separator("emptyStepGroup"));
        menu.add((IContributionItem)new Separator("stepGroup"));
        menu.add((IContributionItem)new GroupMarker("stepIntoGroup"));
        menu.add((IContributionItem)new GroupMarker("stepOverGroup"));
        menu.add((IContributionItem)new GroupMarker("stepReturnGroup"));
        menu.add((IContributionItem)new Separator("renderGroup"));
        menu.add((IContributionItem)new Separator("emptyThreadGroup"));
        menu.add((IContributionItem)new Separator("threadGroup"));
        menu.add((IContributionItem)new Separator("emptyLaunchGroup"));
        menu.add((IContributionItem)new Separator("launchGroup"));
        IStructuredSelection selection = (IStructuredSelection)this.getSite().getSelectionProvider().getSelection();
        this.updateAndAdd(menu, this.fEditConfigAction, selection);
        this.updateAndAdd(menu, this.fAddToFavoritesAction, selection);
        this.updateAndAdd(menu, this.fEditSourceAction, selection);
        this.updateAndAdd(menu, this.fLookupAction, selection);
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("renderGroup"));
        menu.add((IContributionItem)new Separator("propertyGroup"));
        PropertyDialogAction action = (PropertyDialogAction)this.getAction("Properties");
        action.setEnabled(action.isApplicableForSelection());
        menu.add((IAction)action);
        menu.add((IContributionItem)new Separator("additions"));
    }

    private void updateAndAdd(IMenuManager menu, SelectionListenerAction action, IStructuredSelection selection) {
        action.selectionChanged(selection);
        if (action.isEnabled()) {
            menu.add((IAction)action);
        }
    }

    public void autoExpand(Object element, boolean refreshNeeded, boolean selectNeeded) {
        Object selectee = element;
        IThread[] children = null;
        if (element instanceof IThread) {
            if (!refreshNeeded) {
                refreshNeeded = this.threadRefreshNeeded((IThread)element);
            }
            try {
                selectee = ((IThread)element).getTopStackFrame();
            }
            catch (DebugException de) {
                // empty catch block
            }
            if (selectee == null) {
                selectee = element;
            }
        } else if (element instanceof ILaunch) {
            IDebugTarget dt = ((ILaunch)element).getDebugTarget();
            if (dt != null) {
                selectee = dt;
                try {
                    children = dt.getThreads();
                }
                catch (DebugException de) {
                    DebugUIPlugin.log(de);
                }
            } else {
                IProcess[] processes = ((ILaunch)element).getProcesses();
                if (processes.length != 0) {
                    selectee = processes[0];
                }
            }
        }
        if (refreshNeeded) {
            this.getStructuredViewer().refresh(element);
        }
        if (selectNeeded) {
            this.getViewer().setSelection((ISelection)new StructuredSelection(selectee), true);
        }
        if (children != null && children.length > 0) {
            this.getStructuredViewer().reveal((Object)children[0]);
        }
    }

    protected boolean threadRefreshNeeded(IThread thread) {
        LaunchViewer viewer = (LaunchViewer)this.getStructuredViewer();
        ILaunch launch = thread.getLaunch();
        TreeItem[] launches = viewer.getTree().getItems();
        block2: for (int i = 0; i < launches.length; ++i) {
            if (launches[i].getData() != launch) continue;
            IDebugTarget target = thread.getDebugTarget();
            TreeItem[] targets = launches[i].getItems();
            for (int j = 0; j < targets.length; ++j) {
                if (targets[j].getData() != target) continue;
                TreeItem[] threads = targets[j].getItems();
                for (int k = 0; k < threads.length; ++k) {
                    if (threads[k].getData() != thread) continue;
                    IStackFrame[] frames = null;
                    try {
                        frames = thread.getStackFrames();
                    }
                    catch (DebugException exception) {
                        return true;
                    }
                    TreeItem[] treeFrames = threads[k].getItems();
                    if (frames.length != treeFrames.length) {
                        return true;
                    }
                    int numFrames = treeFrames.length;
                    for (int l = 0; l < numFrames; ++l) {
                        if (treeFrames[l].getData() == frames[l]) continue;
                        return true;
                    }
                    break block2;
                }
                break block2;
            }
            break;
        }
        return false;
    }

    protected IStackFrame getStackFrame() {
        return this.fStackFrame;
    }

    protected void setStackFrame(IStackFrame frame) {
        this.fStackFrame = frame;
    }

    private void setEditorInput(IEditorInput editorInput) {
        this.fEditorInput = editorInput;
    }

    protected IEditorInput getEditorInput() {
        return this.fEditorInput;
    }

    private void setEditorId(String editorId) {
        this.fEditorId = editorId;
    }

    protected String getEditorId() {
        return this.fEditorId;
    }

    private void setSourceElement(Object sourceElement) {
        this.fSourceElement = sourceElement;
    }

    protected Object getSourceElement() {
        return this.fSourceElement;
    }

    protected void setActive(boolean active) {
        this.fIsActive = active;
    }

    protected boolean isActive() {
        return this.fIsActive && this.getViewer() != null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals(IDebugUIConstants.PREF_REUSE_EDITOR)) {
            this.fReuseEditor = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IDebugUIConstants.PREF_REUSE_EDITOR);
        } else if (property.equals(IDebugUIConstants.PREF_MANAGE_VIEW_PERSPECTIVES)) {
            this.fContextListener.reloadAutoManagePerspectives(((IStructuredSelection)this.getViewer().getSelection()).getFirstElement());
        } else if (property.equals(LaunchViewContextListener.PREF_OPENED_VIEWS) && this.fContextListener != null) {
            this.fContextListener.loadOpenedViews();
        } else if (property.equals(LaunchViewContextListener.PREF_VIEWS_TO_NOT_OPEN) && this.fContextListener != null) {
            this.fContextListener.loadViewsToNotOpen();
        } else if (property.equals(IInternalDebugUIConstants.PREF_TRACK_VIEWS) && this.fContextListener != null) {
            this.fContextListener.loadTrackViews();
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.fReuseEditor && this.fEditor != null) {
            IWorkbenchWindow dwindow = this.getSite().getWorkbenchWindow();
            if (dwindow == null) {
                return;
            }
            IWorkbenchPage page = dwindow.getActivePage();
            if (page == null) {
                return;
            }
            IEditorReference[] refs = page.getEditorReferences();
            int index = -1;
            for (int i = 0; i < refs.length; ++i) {
                if (!this.fEditor.equals(refs[i].getEditor(false))) continue;
                index = i;
                break;
            }
            if (index >= 0) {
                memento.putString(IDebugUIConstants.PREF_REUSE_EDITOR, Integer.toString(index));
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                delta.accept(this.getVisitor());
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
    }

    protected IResourceDeltaVisitor getVisitor() {
        if (this.fVisitor == null) {
            this.fVisitor = new LaunchViewVisitor();
        }
        return this.fVisitor;
    }

    protected void becomesVisible() {
        super.becomesVisible();
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        if (selection.isEmpty() || !selection.getFirstElement().equals(this.getStackFrame())) {
            this.initializeSelection();
        }
    }

    public boolean show(ShowInContext context) {
        Object obj;
        IStructuredSelection ss;
        ISelection selection = context.getSelection();
        if (selection != null && selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && ((obj = ss.getFirstElement()) instanceof IDebugTarget || obj instanceof IProcess)) {
            this.getViewer().setSelection(selection, true);
            return true;
        }
        return false;
    }

    public ShowInContext getShowInContext() {
        Object sourceElement;
        IStructuredSelection selection;
        if (this.isActive() && !(selection = (IStructuredSelection)this.getViewer().getSelection()).isEmpty() && (sourceElement = this.getSourceElement()) instanceof IAdaptable && ((IAdaptable)sourceElement).getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = LaunchView.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource) != null) {
            return new ShowInContext(null, (ISelection)new StructuredSelection(this.getSourceElement()));
        }
        return null;
    }

    public String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.ui.views.ResourceNavigator"};
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part != null && part.equals(this.fEditor)) {
            this.fEditor = null;
        }
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part == this) {
            this.setActive(true);
            this.getSite().getPage().showActionSet(IDebugUIConstants.DEBUG_ACTION_SET);
        }
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part == this) {
            this.fContextListener = new LaunchViewContextListener(this);
        }
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class LaunchViewVisitor
    implements IResourceDeltaVisitor {
        LaunchViewVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null) {
                return false;
            }
            IResource resource = delta.getResource();
            if (0 != (delta.getFlags() & 0x4000)) {
                IProject project;
                if (resource instanceof IProject && !(project = (IProject)resource).isOpen()) {
                    LaunchView.this.cleanup();
                }
                return false;
            }
            return resource instanceof IWorkspaceRoot;
        }
    }
}

