/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class EditorRegistryReader
extends RegistryReader {
    private static final String ATT_CLASS = "class";
    private static final String ATT_NAME = "name";
    private static final String TAG_EDITOR = "editor";
    private static final String P_TRUE = "true";
    private static final String ATT_COMMAND = "command";
    private static final String ATT_LAUNCHER = "launcher";
    private static final String ATT_DEFAULT = "default";
    public static final String ATT_ID = "id";
    private static final String ATT_ICON = "icon";
    private static final String ATT_EXTENSIONS = "extensions";
    private static final String ATT_FILENAMES = "filenames";
    private EditorRegistry editorRegistry;

    protected void addEditors(boolean readAll, EditorRegistry registry) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        this.editorRegistry = registry;
        this.readRegistry(extensionRegistry, "org.eclipse.ui", "editors");
    }

    protected boolean readElement(IConfigurationElement element) {
        String filenamesString;
        String extensionsString;
        if (!element.getName().equals(TAG_EDITOR)) {
            return false;
        }
        EditorDescriptor editor = new EditorDescriptor();
        editor.setConfigurationElement(element);
        String id = element.getAttribute(ATT_ID);
        if (id == null) {
            EditorRegistryReader.logMissingAttribute(element, ATT_ID);
            return true;
        }
        editor.setID(id);
        IExtension extension = element.getDeclaringExtension();
        editor.setPluginIdentifier(extension.getNamespace());
        ArrayList<String> extensionsVector = new ArrayList<String>();
        ArrayList<String> filenamesVector = new ArrayList<String>();
        boolean defaultEditor = false;
        String name = element.getAttribute(ATT_NAME);
        if (name == null) {
            EditorRegistryReader.logMissingAttribute(element, ATT_NAME);
            return true;
        }
        editor.setName(name);
        String icon = element.getAttribute(ATT_ICON);
        if (icon == null && element.getAttribute(ATT_CLASS) != null) {
            EditorRegistryReader.logMissingAttribute(element, ATT_ICON);
            return true;
        }
        if (icon != null) {
            String extendingPluginId = extension.getNamespace();
            editor.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin(extendingPluginId, icon));
            editor.setImageFilename(icon);
        }
        if ((extensionsString = element.getAttribute(ATT_EXTENSIONS)) != null) {
            StringTokenizer tokenizer = new StringTokenizer(extensionsString, ",");
            while (tokenizer.hasMoreTokens()) {
                extensionsVector.add(tokenizer.nextToken().trim());
            }
        }
        if ((filenamesString = element.getAttribute(ATT_FILENAMES)) != null) {
            StringTokenizer tokenizer = new StringTokenizer(filenamesString, ",");
            while (tokenizer.hasMoreTokens()) {
                filenamesVector.add(tokenizer.nextToken().trim());
            }
        }
        String launcher = element.getAttribute(ATT_LAUNCHER);
        String command = element.getAttribute(ATT_COMMAND);
        if (launcher != null) {
            editor.setLauncher(launcher);
            editor.setOpenMode(4);
        } else if (command != null) {
            editor.setFileName(command);
            editor.setOpenMode(4);
            if (icon == null) {
                editor.setImageDescriptor(WorkbenchImages.getImageDescriptorFromProgram(command, 0));
            }
        } else {
            String className = element.getAttribute(ATT_CLASS);
            editor.setClassName(className);
            editor.setOpenMode(1);
        }
        String def = element.getAttribute(ATT_DEFAULT);
        if (def != null) {
            defaultEditor = def.equalsIgnoreCase(P_TRUE);
        }
        this.editorRegistry.addEditorFromPlugin(editor, extensionsVector, filenamesVector, defaultEditor);
        return true;
    }

    public void readElement(EditorRegistry editorRegistry, IConfigurationElement element) {
        this.editorRegistry = editorRegistry;
        this.readElement(element);
    }
}

